/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import shohaku.core.helpers.HHash;
import shohaku.core.lang.Boxing;
import shohaku.core.lang.RangeNumber;

public final class RangeLong
implements RangeNumber {
    private static final long serialVersionUID = 3907316516447989638L;
    private final long min;
    private final long max;

    public RangeLong() {
        this.min = 0L;
        this.max = 0L;
    }

    public RangeLong(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public Number getMaxValue() {
        return Boxing.box(this.max);
    }

    public Number getMinValue() {
        return Boxing.box(this.min);
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public boolean contain(long n) {
        return this.min <= n && n <= this.max;
    }

    public int hashCode() {
        return HHash.hash(this.min) + HHash.hash(this.max);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangeLong)) {
            return false;
        }
        RangeLong r = (RangeLong)o;
        return r.min == this.min && r.max == this.max;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.min)) + ":" + String.valueOf(this.max);
    }
}

