/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import shohaku.core.lang.Boxing;
import shohaku.core.lang.RangeNumber;

public final class RangeInt
implements RangeNumber {
    private static final long serialVersionUID = -3934190991691236269L;
    private final int min;
    private final int max;

    public RangeInt() {
        this.min = 0;
        this.max = 0;
    }

    public RangeInt(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public Number getMaxValue() {
        return Boxing.box(this.max);
    }

    public Number getMinValue() {
        return Boxing.box(this.min);
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public boolean contain(int n) {
        return this.min <= n && n <= this.max;
    }

    public int hashCode() {
        return this.min + this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangeInt)) {
            return false;
        }
        RangeInt r = (RangeInt)o;
        return r.min == this.min && r.max == this.max;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.min)) + ":" + String.valueOf(this.max);
    }
}

