/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

class UnicodeEscapesCoder {
    static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    UnicodeEscapesCoder() {
    }

    static String decode(CharSequence src) {
        int len = src.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            char aChar;
            if ((aChar = src.charAt(x++)) == '\\') {
                if ((aChar = src.charAt(x++)) == 'u') {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = src.charAt(x++);
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                switch (aChar) {
                    case 'b': {
                        aChar = '\b';
                        break;
                    }
                    case 't': {
                        aChar = '\t';
                        break;
                    }
                    case 'n': {
                        aChar = '\n';
                        break;
                    }
                    case 'f': {
                        aChar = '\f';
                        break;
                    }
                    case 'r': {
                        aChar = '\r';
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '\\': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Malformed \\x encoding.");
                    }
                }
                outBuffer.append(aChar);
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    static String encode(CharSequence src) {
        int len = src.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = src.charAt(x);
            outBuffer.append('\\');
            outBuffer.append('u');
            outBuffer.append(UnicodeEscapesCoder.toHex(aChar >> 12 & 0xF));
            outBuffer.append(UnicodeEscapesCoder.toHex(aChar >> 8 & 0xF));
            outBuffer.append(UnicodeEscapesCoder.toHex(aChar >> 4 & 0xF));
            outBuffer.append(UnicodeEscapesCoder.toHex(aChar & 0xF));
            ++x;
        }
        return outBuffer.toString();
    }

    static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

