/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import shohaku.core.helpers.HFmt;
import shohaku.core.lang.VariableInteger;

class LogHelper {
    static final int REPETITION_LIMIT = 255;

    LogHelper() {
    }

    static String array(Object o) {
        if (o == null) {
            return "null";
        }
        if (o.getClass().isArray()) {
            return LogHelper.toArrayString(o, new VariableInteger());
        }
        return String.valueOf(o);
    }

    static String arrays(Object o) {
        if (o == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        LogHelper.append(o, buf, new VariableInteger());
        return buf.toString();
    }

    private static String toArrayString(Object a, VariableInteger count) {
        Class<?> type = a.getClass().getComponentType();
        if (type.isPrimitive()) {
            if (type == Character.TYPE) {
                return LogHelper.toString((char[])a, count);
            }
            if (type == Boolean.TYPE) {
                return LogHelper.toString((boolean[])a, count);
            }
            if (type == Byte.TYPE) {
                return LogHelper.toString((byte[])a, count);
            }
            if (type == Short.TYPE) {
                return LogHelper.toString((short[])a, count);
            }
            if (type == Integer.TYPE) {
                return LogHelper.toString((int[])a, count);
            }
            if (type == Long.TYPE) {
                return LogHelper.toString((long[])a, count);
            }
            if (type == Float.TYPE) {
                return LogHelper.toString((float[])a, count);
            }
            if (type == Double.TYPE) {
                return LogHelper.toString((double[])a, count);
            }
        }
        return LogHelper.toString((Object[])a, count);
    }

    private static String toString(long[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        LogHelper.appendClass(a, buf);
        if (a.length == 0) {
            return buf.append("[]").toString();
        }
        buf.append('[');
        buf.append(a[0]);
        count.increment();
        int i = 1;
        while (i < a.length) {
            if (count.intValue() >= 255) {
                buf.append("...");
                break;
            }
            buf.append(", ");
            buf.append(a[i]);
            count.increment();
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    private static String toString(int[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        LogHelper.appendClass(a, buf);
        if (a.length == 0) {
            return buf.append("[]").toString();
        }
        buf.append('[');
        buf.append(a[0]);
        count.increment();
        int i = 1;
        while (i < a.length) {
            if (count.intValue() >= 255) {
                buf.append("...");
                break;
            }
            buf.append(", ");
            buf.append(a[i]);
            count.increment();
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    private static String toString(short[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        LogHelper.appendClass(a, buf);
        if (a.length == 0) {
            return buf.append("[]").toString();
        }
        buf.append('[');
        buf.append(a[0]);
        count.increment();
        int i = 1;
        while (i < a.length) {
            if (count.intValue() >= 255) {
                buf.append("...");
                break;
            }
            buf.append(", ");
            buf.append(a[i]);
            count.increment();
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    private static String toString(char[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        LogHelper.appendClass(a, buf);
        if (a.length == 0) {
            return buf.append("[]").toString();
        }
        buf.append('[');
        buf.append(a[0]);
        count.increment();
        int i = 1;
        while (i < a.length) {
            if (count.intValue() >= 255) {
                buf.append("...");
                break;
            }
            buf.append(", ");
            buf.append(a[i]);
            count.increment();
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    private static String toString(byte[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        LogHelper.appendClass(a, buf);
        if (a.length == 0) {
            return buf.append("[]").toString();
        }
        buf.append('[');
        buf.append(a[0]);
        count.increment();
        int i = 1;
        while (i < a.length) {
            if (count.intValue() >= 255) {
                buf.append("...");
                break;
            }
            buf.append(", ");
            buf.append(a[i]);
            count.increment();
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    private static String toString(boolean[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        LogHelper.appendClass(a, buf);
        if (a.length == 0) {
            return buf.append("[]").toString();
        }
        buf.append('[');
        buf.append(a[0]);
        count.increment();
        int i = 1;
        while (i < a.length) {
            if (count.intValue() >= 255) {
                buf.append("...");
                break;
            }
            buf.append(", ");
            buf.append(a[i]);
            count.increment();
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    private static String toString(float[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        LogHelper.appendClass(a, buf);
        if (a.length == 0) {
            return buf.append("[]").toString();
        }
        buf.append('[');
        buf.append(a[0]);
        count.increment();
        int i = 1;
        while (i < a.length) {
            if (count.intValue() >= 255) {
                buf.append("...");
                break;
            }
            buf.append(", ");
            buf.append(a[i]);
            count.increment();
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    private static String toString(double[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        LogHelper.appendClass(a, buf);
        if (a.length == 0) {
            return buf.append("[]").toString();
        }
        buf.append('[');
        buf.append(a[0]);
        count.increment();
        int i = 1;
        while (i < a.length) {
            if (count.intValue() >= 255) {
                buf.append("...");
                break;
            }
            buf.append(", ");
            buf.append(a[i]);
            count.increment();
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    private static String toString(Object[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        LogHelper.appendClass(a, buf);
        if (a.length == 0) {
            return buf.append("[]").toString();
        }
        int i = 0;
        while (i < a.length) {
            if (i == 0) {
                buf.append('[');
            } else {
                buf.append(", ");
            }
            if (count.intValue() >= 255) {
                buf.append("...");
                break;
            }
            buf.append(String.valueOf(a[i]));
            count.increment();
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    private static String toDeepString(Object[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        LogHelper.appendClass(a, buf);
        if (a.length == 0) {
            return buf.append("[]").toString();
        }
        int i = 0;
        while (i < a.length) {
            if (i == 0) {
                buf.append('[');
            } else {
                buf.append(", ");
            }
            if (LogHelper.append(a[i], buf, count)) break;
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    private static String toDeepString(Map map, VariableInteger count) {
        if (map == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        LogHelper.appendClass(map, buf);
        if (map.size() == 0) {
            return buf.append("{}").toString();
        }
        buf.append('{');
        Iterator i = map.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Map.Entry e = i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            if (key == map) {
                buf.append("(this Map)");
            } else if (LogHelper.append(key, buf, count)) break;
            buf.append('=');
            if (value == map) {
                buf.append("(this Map)");
            } else if (LogHelper.append(value, buf, count)) break;
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append('}');
        return buf.toString();
    }

    private static String toDeepString(Collection coll, VariableInteger count) {
        if (coll == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        LogHelper.appendClass(coll, buf);
        if (coll.size() == 0) {
            return buf.append("[]").toString();
        }
        buf.append('[');
        Iterator i = coll.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Object e = i.next();
            if (e == coll) {
                buf.append("(this Collection)");
            } else if (LogHelper.append(e, buf, count)) break;
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    private static boolean append(Object o, StringBuffer buf, VariableInteger count) {
        if (count.intValue() >= 255) {
            buf.append("...");
            return true;
        }
        count.increment();
        if (o == null) {
            buf.append("null");
            return false;
        }
        if (o.getClass().isArray()) {
            if (o instanceof Object[]) {
                buf.append(LogHelper.toDeepString((Object[])o, count));
            } else {
                buf.append(LogHelper.toArrayString(o, count));
            }
        } else if (o instanceof Map) {
            buf.append(LogHelper.toDeepString((Map)o, count));
        } else if (o instanceof Collection) {
            buf.append(LogHelper.toDeepString((Collection)o, count));
        } else if (o instanceof Timestamp) {
            buf.append(String.valueOf(o));
        } else if (o instanceof Time) {
            buf.append(String.valueOf(o));
        } else if (o instanceof Date) {
            buf.append(HFmt.formatDate(o));
        } else if (o instanceof Calendar) {
            buf.append(HFmt.formatDate(o));
        } else {
            buf.append(String.valueOf(o));
        }
        return false;
    }

    private static void appendClass(Object o, StringBuffer buf) {
        buf.append('<');
        buf.append(o.getClass().getName());
        buf.append('>');
    }
}

