/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import shohaku.core.helpers.Constants;
import shohaku.core.helpers.HCnv;
import shohaku.core.helpers.HSeek;
import shohaku.core.lang.RangeInt;

public class HValid {
    public static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final List DATETIME_FORMAT_LIST = Constants.DATETIME_FORMAT_LIST;

    public static boolean isCharsOnly(CharSequence cs, char[] chars) {
        if (cs == null) {
            return false;
        }
        return HSeek.orOtherIndexOf(cs, chars, 1) < 0;
    }

    public static boolean isCharsOnly(CharSequence cs, char[] chars, int fromIndex, int toIndex) {
        if (cs == null) {
            return false;
        }
        return HSeek.orOtherIndexOf(cs, toIndex, chars, fromIndex) < 0;
    }

    public static boolean isCharsRange(CharSequence cs, RangeInt rangeChar) {
        if (cs == null) {
            return false;
        }
        int len = cs.length();
        int i = 0;
        while (i < len) {
            if (!HValid.isRange(cs.charAt(i), rangeChar.getMin(), rangeChar.getMax())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isCharsRange(CharSequence cs, RangeInt[] rangeChars) {
        if (cs == null) {
            return false;
        }
        int len = cs.length();
        boolean hit = false;
        int i = 0;
        while (i < len) {
            char c = cs.charAt(i);
            int j = 0;
            while (j < rangeChars.length) {
                RangeInt r = rangeChars[j];
                if (HValid.isRange(c, r.getMin(), r.getMax())) {
                    hit = true;
                    break;
                }
                ++j;
            }
            if (!hit) {
                return false;
            }
            hit = false;
            ++i;
        }
        return true;
    }

    public static boolean isDateTime(CharSequence date) {
        return HValid.isDateTime(date, DATETIME_FORMAT_LIST);
    }

    public static boolean isDateTime(CharSequence date, String pattern) {
        return HValid.isDateTime(date, Locale.getDefault(), pattern);
    }

    public static boolean isDateTime(CharSequence date, Locale locale, String pattern) {
        return HValid.isDateTime(date, new DateFormatSymbols(locale), pattern);
    }

    public static boolean isDateTime(CharSequence date, DateFormatSymbols symbols, String pattern) {
        return HValid.isDateTime(date, symbols, pattern, false);
    }

    public static boolean isDateTime(CharSequence date, DateFormatSymbols symbols, String pattern, boolean lenient) {
        return date == null ? false : HCnv.toDateTime(date, symbols, pattern, lenient) != null;
    }

    public static boolean isDateTime(CharSequence date, Collection patterns) {
        return HValid.isDateTime(date, Locale.getDefault(), patterns);
    }

    public static boolean isDateTime(CharSequence date, Locale locale, Collection patterns) {
        return HValid.isDateTime(date, new DateFormatSymbols(locale), patterns);
    }

    public static boolean isDateTime(CharSequence date, DateFormatSymbols symbols, Collection patterns) {
        return HValid.isDateTime(date, symbols, patterns, false);
    }

    public static boolean isDateTime(CharSequence date, DateFormatSymbols symbols, Collection patterns, boolean lenient) {
        return date == null ? false : HCnv.toDateTime(date, symbols, patterns, lenient) != null;
    }

    public static boolean isDecimal(CharSequence num, String pattern) {
        return HValid.isDecimal(num, Locale.getDefault(), pattern);
    }

    public static boolean isDecimal(CharSequence num, Locale locale, String pattern) {
        return HValid.isDecimal(num, new DecimalFormatSymbols(locale), pattern);
    }

    public static boolean isDecimal(CharSequence num, DecimalFormatSymbols symbols, String pattern) {
        return num == null ? false : HCnv.toDecimal(num, symbols, pattern) != null;
    }

    public static boolean isDecimal(CharSequence num, Collection patterns) {
        return HValid.isDecimal(num, Locale.getDefault(), patterns);
    }

    public static boolean isDecimal(CharSequence num, Locale locale, Collection patterns) {
        return HValid.isDecimal(num, new DecimalFormatSymbols(locale), patterns);
    }

    public static boolean isDecimal(CharSequence num, DecimalFormatSymbols symbols, Collection patterns) {
        return num == null ? false : HCnv.toDecimal(num, symbols, patterns) != null;
    }

    public static boolean isEncode(char c, String charsetName) throws UnsupportedCharsetException, IllegalCharsetNameException, UnsupportedOperationException {
        return HValid.isEncode(c, Charset.forName(charsetName));
    }

    public static boolean isEncode(char c, Charset charset) throws UnsupportedOperationException {
        CharsetEncoder cEncoder = charset.newEncoder();
        return cEncoder.canEncode(c);
    }

    public static boolean isEncode(CharSequence cs, String charsetName) throws UnsupportedCharsetException, IllegalCharsetNameException, UnsupportedOperationException {
        return HValid.isEncode(cs, Charset.forName(charsetName));
    }

    public static boolean isEncode(CharSequence cs, Charset charset) throws UnsupportedOperationException {
        CharsetEncoder cEncoder = charset.newEncoder();
        return cEncoder.canEncode(cs);
    }

    public static boolean isRange(int n, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("from > to (" + from + " > " + to + ")");
        }
        return from <= n && n <= to;
    }

    public static boolean isRange(long n, long from, long to) {
        if (from > to) {
            throw new IllegalArgumentException("from > to (" + from + " > " + to + ")");
        }
        return from <= n && n <= to;
    }

    public static boolean isRange(float n, float from, float to) {
        if (from > to) {
            throw new IllegalArgumentException("from > to (" + from + " > " + to + ")");
        }
        return HValid.isMin(n, from) && HValid.isMax(n, to);
    }

    public static boolean isRange(double n, double from, double to) {
        if (from > to) {
            throw new IllegalArgumentException("from > to (" + from + " > " + to + ")");
        }
        return HValid.isMin(n, from) && HValid.isMax(n, to);
    }

    public static boolean isLongBitsRange(float n, float from, float to) {
        if (Float.compare(from, to) > 0) {
            throw new IllegalArgumentException("from > to (" + from + " > " + to + ")");
        }
        return HValid.isLongBitsMin(n, from) && HValid.isLongBitsMax(n, to);
    }

    public static boolean isLongBitsRange(double n, double from, double to) {
        if (Double.compare(from, to) > 0) {
            throw new IllegalArgumentException("from > to (" + from + " > " + to + ")");
        }
        return HValid.isLongBitsMin(n, from) && HValid.isLongBitsMax(n, to);
    }

    public static boolean isMin(int n, int min) {
        return min <= n;
    }

    public static boolean isMin(long n, long min) {
        return min <= n;
    }

    public static boolean isMin(float n, float min) {
        return min <= n;
    }

    public static boolean isMin(double n, double min) {
        return min <= n;
    }

    public static boolean isLongBitsMin(float n, float min) {
        return Float.compare(n, min) >= 0;
    }

    public static boolean isLongBitsMin(double n, double min) {
        return Double.compare(n, min) >= 0;
    }

    public static boolean isMax(int n, int max) {
        return n <= max;
    }

    public static boolean isMax(long n, long max) {
        return n <= max;
    }

    public static boolean isMax(float n, float max) {
        return n <= max;
    }

    public static boolean isMax(double n, double max) {
        return n <= max;
    }

    public static boolean isLongBitsMax(float n, float max) {
        return Float.compare(n, max) <= 0;
    }

    public static boolean isLongBitsMax(double n, double max) {
        return Double.compare(n, max) <= 0;
    }

    public static boolean isSize(CharSequence cs, int size) {
        return cs.length() == size;
    }

    public static boolean isRangeSize(CharSequence cs, int min, int max) {
        return HValid.isRange(cs.length(), min, max);
    }

    public static boolean isMinSize(CharSequence cs, int min) {
        return HValid.isMin(cs.length(), min);
    }

    public static boolean isMaxSize(CharSequence cs, int max) {
        return HValid.isMax(cs.length(), max);
    }

    public static boolean isNegative(int n) {
        return n < 0;
    }

    public static boolean isNegative(long n) {
        return 0L > n;
    }

    public static boolean isNegative(float n) {
        return 0.0f > n;
    }

    public static boolean isNegative(double n) {
        return 0.0 > n;
    }

    public static boolean isLongBitsNegative(float n) {
        return Float.compare(n, 0.0f) < 0;
    }

    public static boolean isLongBitsNegative(double n) {
        return Double.compare(n, 0.0) < 0;
    }

    public static boolean isZeroOrNegative(int n) {
        return n <= 0;
    }

    public static boolean isZeroOrNegative(long n) {
        return 0L >= n;
    }

    public static boolean isZeroOrNegative(float n) {
        return 0.0f >= n;
    }

    public static boolean isZeroOrNegative(double n) {
        return 0.0 >= n;
    }

    public static boolean isLongBitsZeroOrNegative(float n) {
        return Float.compare(n, 0.0f) <= 0;
    }

    public static boolean isLongBitsZeroOrNegative(double n) {
        return Double.compare(n, 0.0) <= 0;
    }

    public static boolean isPositive(int n) {
        return n > 0;
    }

    public static boolean isPositive(long n) {
        return 0L < n;
    }

    public static boolean isPositive(float n) {
        return 0.0f < n;
    }

    public static boolean isPositive(double n) {
        return 0.0 < n;
    }

    public static boolean isLongBitsPositive(float n) {
        return Float.compare(n, -0.0f) > 0;
    }

    public static boolean isLongBitsPositive(double n) {
        return Double.compare(n, -0.0) > 0;
    }

    public static boolean isZeroOrPositive(int n) {
        return n >= 0;
    }

    public static boolean isZeroOrPositive(long n) {
        return 0L <= n;
    }

    public static boolean isZeroOrPositive(float n) {
        return 0.0f <= n;
    }

    public static boolean isZeroOrPositive(double n) {
        return 0.0 <= n;
    }

    public static boolean isLongBitsZeroOrPositive(float n) {
        return Float.compare(n, -0.0f) >= 0;
    }

    public static boolean isLongBitsZeroOrPositive(double n) {
        return Double.compare(n, -0.0) >= 0;
    }

    public static boolean isInfiniteOrNaN(Number val) {
        if (val instanceof Float) {
            return HValid.isInfiniteOrNaN((Float)val);
        }
        if (val instanceof Double) {
            return HValid.isInfiniteOrNaN((Double)val);
        }
        return false;
    }

    public static boolean isInfiniteOrNaN(Float val) {
        return val.isInfinite() || val.isNaN();
    }

    public static boolean isInfiniteOrNaN(float val) {
        return Float.isInfinite(val) || Float.isNaN(val);
    }

    public static boolean isInfiniteOrNaN(Double val) {
        return val.isInfinite() || val.isNaN();
    }

    public static boolean isInfiniteOrNaN(double val) {
        return Double.isInfinite(val) || Double.isNaN(val);
    }

    public static boolean isRangeAll(byte[] a, byte from, byte to) {
        int i = 0;
        while (i < a.length) {
            if (!HValid.isRange(a[i], from, to)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRangeAll(short[] a, short from, short to) {
        int i = 0;
        while (i < a.length) {
            if (!HValid.isRange(a[i], from, to)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRangeAll(int[] a, int from, int to) {
        int i = 0;
        while (i < a.length) {
            if (!HValid.isRange(a[i], from, to)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRangeAll(long[] a, long from, long to) {
        int i = 0;
        while (i < a.length) {
            if (!HValid.isRange(a[i], from, to)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRangeAll(float[] a, float from, float to) {
        int i = 0;
        while (i < a.length) {
            if (!HValid.isRange(a[i], from, to)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRangeAll(double[] a, double from, double to) {
        int i = 0;
        while (i < a.length) {
            if (!HValid.isRange(a[i], from, to)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isLongBitsRangeAll(float[] a, float from, float to) {
        int i = 0;
        while (i < a.length) {
            if (!HValid.isLongBitsRange(a[i], from, to)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isLongBitsRangeAll(double[] a, double from, double to) {
        int i = 0;
        while (i < a.length) {
            if (!HValid.isLongBitsRange(a[i], from, to)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

