/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import shohaku.core.helpers.HEval;
import shohaku.core.helpers.HLog;
import shohaku.core.lang.RangeInt;

public class HSeek {
    public static Object notNull(Object e, Object e2) {
        return e != null ? e : e2;
    }

    public static Object notNull(Object e, Object e2, Object e3) {
        return e != null ? e : (e2 != null ? e2 : e3);
    }

    public static String notEmpty(String e, String e2) {
        return !HEval.isEmpty(e) ? e : e2;
    }

    public static String notEmpty(String e, String e2, String e3) {
        return !HEval.isEmpty(e) ? e : (!HEval.isEmpty(e2) ? e2 : e3);
    }

    public static String notBlank(String e, String e2) {
        return !HEval.isBlank(e) ? e : e2;
    }

    public static String notBlank(String e, String e2, String e3) {
        return !HEval.isBlank(e) ? e : (!HEval.isBlank(e2) ? e2 : e3);
    }

    public static int skip(CharSequence cs, RangeInt range, int fromIndex) {
        int inx = fromIndex;
        while (inx < cs.length()) {
            if (!range.contain(cs.charAt(inx))) break;
            ++inx;
        }
        return inx;
    }

    public static int skip(CharSequence cs, RangeInt[] ranges, int fromIndex) {
        int inx = fromIndex;
        while (inx < cs.length()) {
            char c = cs.charAt(inx);
            boolean hit = false;
            int i = 0;
            while (i < ranges.length) {
                if (ranges[i].contain(c)) {
                    hit = true;
                    break;
                }
                ++i;
            }
            if (!hit) break;
            ++inx;
        }
        return inx;
    }

    public static int skip(CharSequence cs, char c, int fromIndex) {
        int inx = fromIndex;
        while (inx < cs.length()) {
            if (cs.charAt(inx) != c) break;
            ++inx;
        }
        return inx;
    }

    public static int skipGreater(CharSequence cs, int c, int fromIndex) {
        int inx = fromIndex;
        while (inx < cs.length()) {
            if (cs.charAt(inx) <= c) break;
            ++inx;
        }
        return inx;
    }

    public static int skipLess(CharSequence cs, int c, int fromIndex) {
        int inx = fromIndex;
        while (inx < cs.length()) {
            if (cs.charAt(inx) >= c) break;
            ++inx;
        }
        return inx;
    }

    public static int skipSp(CharSequence cs, int fromIndex) {
        int inx = fromIndex;
        while (inx < cs.length()) {
            if (cs.charAt(inx) > ' ') break;
            ++inx;
        }
        return inx;
    }

    public static int skip(CharSequence cs, CharSequence chars, int fromIndex) {
        int charslen = chars.length();
        int inx = fromIndex;
        while (inx < cs.length()) {
            if (!HEval.isStartsWith(cs, chars, inx)) break;
            inx += charslen;
        }
        return inx;
    }

    public static int skip(CharSequence cs, char[] chars, int fromIndex) {
        int inx = fromIndex;
        while (inx < cs.length()) {
            char c = cs.charAt(inx);
            boolean hit = false;
            int i = 0;
            while (i < chars.length) {
                if (c == chars[i]) {
                    hit = true;
                    break;
                }
                ++i;
            }
            if (!hit) break;
            ++inx;
        }
        return inx;
    }

    public static int count(Collection c, Object o) {
        if (c instanceof Set) {
            return c.contains(o) ? 1 : 0;
        }
        int count = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (!HEval.isEquals(i.next(), o)) continue;
            ++count;
        }
        return count;
    }

    public static int indexOf(CharSequence cs, char searchChar, int count) {
        return HSeek.indexOf(cs, 0, cs.length() - 1, searchChar, count);
    }

    public static int indexOf(CharSequence cs, int fromIndex, char searchChar, int count) {
        return HSeek.indexOf(cs, fromIndex, cs.length() - 1, searchChar, count);
    }

    public static int indexOf(CharSequence cs, int fromIndex, int toIndex, char searchChar, int count) {
        block6: {
            int limit;
            int _count;
            block5: {
                if (!HEval.isIndex(cs.length(), fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", cs.length(), fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (count <= 0) break block5;
                int i = fromIndex;
                while (i <= toIndex) {
                    if (cs.charAt(i) == searchChar && ++_count == limit) {
                        return i;
                    }
                    ++i;
                }
                break block6;
            }
            if (count >= 0) break block6;
            int i = toIndex;
            while (i >= fromIndex) {
                if (cs.charAt(i) == searchChar && ++_count == limit) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public static int orIndexOf(CharSequence cs, char[] searchChars, int count) {
        return HSeek.orIndexOf(cs, 0, cs.length() - 1, searchChars, count);
    }

    public static int orIndexOf(CharSequence cs, int fromIndex, char[] searchChars, int count) {
        return HSeek.orIndexOf(cs, fromIndex, cs.length() - 1, searchChars, count);
    }

    public static int orIndexOf(CharSequence cs, int fromIndex, int toIndex, char[] searchChars, int count) {
        block8: {
            int limit;
            int _count;
            block7: {
                if (!HEval.isIndex(cs.length(), fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", cs.length(), fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (count <= 0) break block7;
                int i = fromIndex;
                while (i <= toIndex) {
                    char c = cs.charAt(i);
                    int j = 0;
                    while (j < searchChars.length) {
                        if (c == searchChars[j] && ++_count == limit) {
                            return i;
                        }
                        ++j;
                    }
                    ++i;
                }
                break block8;
            }
            if (count >= 0) break block8;
            int i = toIndex;
            while (i >= fromIndex) {
                char c = cs.charAt(i);
                int j = 0;
                while (j < searchChars.length) {
                    if (c == searchChars[j] && ++_count == limit) {
                        return i;
                    }
                    ++j;
                }
                --i;
            }
        }
        return -1;
    }

    public static int orOtherIndexOf(CharSequence cs, char[] searchChars, int count) {
        return HSeek.orOtherIndexOf(cs, 0, cs.length() - 1, searchChars, count);
    }

    public static int orOtherIndexOf(CharSequence cs, int fromIndex, char[] searchChars, int count) {
        return HSeek.orOtherIndexOf(cs, fromIndex, cs.length() - 1, searchChars, count);
    }

    public static int orOtherIndexOf(CharSequence cs, int fromIndex, int toIndex, char[] searchChars, int count) {
        block10: {
            int limit;
            int _count;
            block9: {
                if (!HEval.isIndex(cs.length(), fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", cs.length(), fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (count <= 0) break block9;
                boolean hit = false;
                int i = fromIndex;
                while (i <= toIndex) {
                    char c = cs.charAt(i);
                    int j = 0;
                    while (j < searchChars.length) {
                        if (c == searchChars[j]) {
                            hit = true;
                            break;
                        }
                        ++j;
                    }
                    if (!hit && ++_count == limit) {
                        return i;
                    }
                    hit = false;
                    ++i;
                }
                break block10;
            }
            if (count >= 0) break block10;
            boolean hit = false;
            int i = toIndex;
            while (i >= fromIndex) {
                char c = cs.charAt(i);
                int j = 0;
                while (j < searchChars.length) {
                    if (c == searchChars[j]) {
                        hit = true;
                        break;
                    }
                    ++j;
                }
                if (!hit && ++_count == limit) {
                    return i;
                }
                hit = false;
                --i;
            }
        }
        return -1;
    }

    public static int indexOf(CharSequence cs, CharSequence searchChars, int count) {
        return HSeek.indexOf(cs, 0, cs.length() - 1, searchChars, count);
    }

    public static int indexOf(CharSequence cs, int fromIndex, CharSequence searchChars, int count) {
        return HSeek.indexOf(cs, fromIndex, cs.length() - 1, searchChars, count);
    }

    public static int indexOf(CharSequence cs, int fromIndex, int toIndex, CharSequence searchChars, int count) {
        block10: {
            int limit;
            int _count;
            block11: {
                if (!HEval.isIndex(cs.length(), fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", cs.length(), fromIndex, toIndex));
                }
                if (searchChars.length() == 0) {
                    return -1;
                }
                _count = 0;
                limit = Math.abs(count);
                if (count <= 0) break block11;
                int i = fromIndex;
                while (i <= toIndex) {
                    int plen = searchChars.length();
                    if (i + plen <= toIndex) {
                        int to = i;
                        int po = 0;
                        boolean match = true;
                        while (--plen >= 0) {
                            if (cs.charAt(to++) == searchChars.charAt(po++)) continue;
                            match = false;
                            break;
                        }
                        if (match && ++_count == limit) {
                            return i;
                        }
                        ++i;
                        continue;
                    }
                    break block10;
                }
                break block10;
            }
            if (count >= 0) break block10;
            int i = toIndex;
            while (i >= fromIndex) {
                int plen = searchChars.length();
                if (i - plen >= fromIndex) {
                    int to = i - plen;
                    int po = 0;
                    boolean match = true;
                    while (--plen >= 0) {
                        if (cs.charAt(to++) == searchChars.charAt(po++)) continue;
                        match = false;
                        break;
                    }
                    if (match && ++_count == limit) {
                        return i;
                    }
                    --i;
                    continue;
                }
                break;
            }
        }
        return -1;
    }

    public static int indexOf(List list, int fromIndex, int toIndex, Object search, int count) {
        block14: {
            int limit;
            int _count;
            block13: {
                if (!HEval.isIndex(list.size(), fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", list.size(), fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (count <= 0) break block13;
                if (search == null) {
                    int i = fromIndex;
                    while (i <= toIndex) {
                        if (list.get(i) == null && ++_count == limit) {
                            return i;
                        }
                        ++i;
                    }
                } else {
                    int i = fromIndex;
                    while (i <= toIndex) {
                        if (search.equals(list.get(i)) && ++_count == limit) {
                            return i;
                        }
                        ++i;
                    }
                }
                break block14;
            }
            if (count >= 0) break block14;
            if (search == null) {
                int i = toIndex;
                while (i >= fromIndex) {
                    if (list.get(i) == null && ++_count == limit) {
                        return i;
                    }
                    --i;
                }
            } else {
                int i = toIndex;
                while (i >= fromIndex) {
                    if (search.equals(list.get(i)) && ++_count == limit) {
                        return i;
                    }
                    --i;
                }
            }
        }
        return -1;
    }

    public static int indexOf(Object[] a, int fromIndex, int toIndex, Object search, int count) {
        block14: {
            int limit;
            int _count;
            block13: {
                if (!HEval.isIndex(a.length, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (count <= 0) break block13;
                if (search == null) {
                    int i = fromIndex;
                    while (i <= toIndex) {
                        if (a[i] == null && ++_count == limit) {
                            return i;
                        }
                        ++i;
                    }
                } else {
                    int i = fromIndex;
                    while (i <= toIndex) {
                        if (search.equals(a[i]) && ++_count == limit) {
                            return i;
                        }
                        ++i;
                    }
                }
                break block14;
            }
            if (count >= 0) break block14;
            if (search == null) {
                int i = toIndex;
                while (i >= fromIndex) {
                    if (a[i] == null && ++_count == limit) {
                        return i;
                    }
                    --i;
                }
            } else {
                int i = toIndex;
                while (i >= fromIndex) {
                    if (search.equals(a[i]) && ++_count == limit) {
                        return i;
                    }
                    --i;
                }
            }
        }
        return -1;
    }

    public static int indexOf(boolean[] a, int fromIndex, int toIndex, boolean search, int count) {
        block6: {
            int limit;
            int _count;
            block5: {
                if (!HEval.isIndex(a.length, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (count <= 0) break block5;
                int i = fromIndex;
                while (i <= toIndex) {
                    if (search == a[i] && ++_count == limit) {
                        return i;
                    }
                    ++i;
                }
                break block6;
            }
            if (count >= 0) break block6;
            int i = toIndex;
            while (i >= fromIndex) {
                if (search == a[i] && ++_count == limit) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public static int indexOf(char[] a, int fromIndex, int toIndex, char search, int count) {
        block6: {
            int limit;
            int _count;
            block5: {
                if (!HEval.isIndex(a.length, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (count <= 0) break block5;
                int i = fromIndex;
                while (i <= toIndex) {
                    if (search == a[i] && ++_count == limit) {
                        return i;
                    }
                    ++i;
                }
                break block6;
            }
            if (count >= 0) break block6;
            int i = toIndex;
            while (i >= fromIndex) {
                if (search == a[i] && ++_count == limit) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public static int indexOf(byte[] a, int fromIndex, int toIndex, byte search, int count) {
        block6: {
            int limit;
            int _count;
            block5: {
                if (!HEval.isIndex(a.length, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (count <= 0) break block5;
                int i = fromIndex;
                while (i <= toIndex) {
                    if (search == a[i] && ++_count == limit) {
                        return i;
                    }
                    ++i;
                }
                break block6;
            }
            if (count >= 0) break block6;
            int i = toIndex;
            while (i >= fromIndex) {
                if (search == a[i] && ++_count == limit) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public static int indexOf(short[] a, int fromIndex, int toIndex, short search, int count) {
        block6: {
            int limit;
            int _count;
            block5: {
                if (!HEval.isIndex(a.length, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (count <= 0) break block5;
                int i = fromIndex;
                while (i <= toIndex) {
                    if (search == a[i] && ++_count == limit) {
                        return i;
                    }
                    ++i;
                }
                break block6;
            }
            if (count >= 0) break block6;
            int i = toIndex;
            while (i >= fromIndex) {
                if (search == a[i] && ++_count == limit) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public static int indexOf(int[] a, int fromIndex, int toIndex, int search, int count) {
        block6: {
            int limit;
            int _count;
            block5: {
                if (!HEval.isIndex(a.length, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (count <= 0) break block5;
                int i = fromIndex;
                while (i <= toIndex) {
                    if (search == a[i] && ++_count == limit) {
                        return i;
                    }
                    ++i;
                }
                break block6;
            }
            if (count >= 0) break block6;
            int i = toIndex;
            while (i >= fromIndex) {
                if (search == a[i] && ++_count == limit) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public static int indexOf(long[] a, int fromIndex, int toIndex, long search, int count) {
        block6: {
            int limit;
            int _count;
            block5: {
                if (!HEval.isIndex(a.length, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (count <= 0) break block5;
                int i = fromIndex;
                while (i <= toIndex) {
                    if (search == a[i] && ++_count == limit) {
                        return i;
                    }
                    ++i;
                }
                break block6;
            }
            if (count >= 0) break block6;
            int i = toIndex;
            while (i >= fromIndex) {
                if (search == a[i] && ++_count == limit) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public static int indexOf(float[] a, int fromIndex, int toIndex, float search, int count) {
        block6: {
            int limit;
            int _count;
            block5: {
                if (!HEval.isIndex(a.length, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (count <= 0) break block5;
                int i = fromIndex;
                while (i <= toIndex) {
                    if (search == a[i] && ++_count == limit) {
                        return i;
                    }
                    ++i;
                }
                break block6;
            }
            if (count >= 0) break block6;
            int i = toIndex;
            while (i >= fromIndex) {
                if (search == a[i] && ++_count == limit) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public static int indexOf(double[] a, int fromIndex, int toIndex, double search, int count) {
        block6: {
            int limit;
            int _count;
            block5: {
                if (!HEval.isIndex(a.length, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (count <= 0) break block5;
                int i = fromIndex;
                while (i <= toIndex) {
                    if (search == a[i] && ++_count == limit) {
                        return i;
                    }
                    ++i;
                }
                break block6;
            }
            if (count >= 0) break block6;
            int i = toIndex;
            while (i >= fromIndex) {
                if (search == a[i] && ++_count == limit) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }
}

