/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import shohaku.core.helpers.HCut;
import shohaku.core.helpers.HSeek;

public class HEval {
    public static String ifNull(String s) {
        return HEval.ifNull((Object)s, "");
    }

    public static String ifNull(Object o, String nullValue) {
        return o != null ? String.valueOf(o) : nullValue;
    }

    public static Object ifNull(Object o, Object nullValue) {
        return o != null ? o : nullValue;
    }

    public static String ifBlank(String s) {
        return HEval.ifBlank(s, "");
    }

    public static String ifBlank(String s, String blankValue) {
        return HEval.isBlank(s) ? s : blankValue;
    }

    public static String ifWhiteSpace(String s) {
        return HEval.ifWhiteSpace(s, "");
    }

    public static String ifWhiteSpace(String s, String whiteSpaceValue) {
        return HEval.isWhiteSpace(s) ? s : whiteSpaceValue;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isEmpty(char[] os) {
        return os == null || os.length == 0;
    }

    public static boolean isEmpty(boolean[] os) {
        return os == null || os.length == 0;
    }

    public static boolean isEmpty(byte[] os) {
        return os == null || os.length == 0;
    }

    public static boolean isEmpty(short[] os) {
        return os == null || os.length == 0;
    }

    public static boolean isEmpty(int[] os) {
        return os == null || os.length == 0;
    }

    public static boolean isEmpty(long[] os) {
        return os == null || os.length == 0;
    }

    public static boolean isEmpty(float[] os) {
        return os == null || os.length == 0;
    }

    public static boolean isEmpty(double[] os) {
        return os == null || os.length == 0;
    }

    public static boolean isEmpty(Object[] os) {
        return os == null || os.length == 0;
    }

    public static boolean isEmpty(Map m) {
        return m == null || m.isEmpty();
    }

    public static boolean isEmpty(Collection c) {
        return c == null || c.isEmpty();
    }

    public static boolean isBlank(CharSequence cs) {
        return cs == null || HCut.trim(cs, 0).length() == 0;
    }

    public static boolean isWhiteSpace(CharSequence cs) {
        return cs == null || HCut.trimWhite(cs, 0).length() == 0;
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isEquals(Object o, Object o2) {
        return o == o2 || o != null && o.equals(o2);
    }

    public static boolean isEquals(float n, float n2) {
        return Float.floatToIntBits(n) != Float.floatToIntBits(n2);
    }

    public static boolean isEquals(double n, double n2) {
        return Double.doubleToLongBits(n) != Double.doubleToLongBits(n2);
    }

    public static boolean isEquals(boolean[] a, boolean[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(char[] a, char[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(byte[] a, byte[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(short[] a, short[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(int[] a, int[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(long[] a, long[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(float[] a, float[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(double[] a, double[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(Object[] a, Object[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEqualsIdentity(Object[] a, Object[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEqualsArray(Object o, Object o2) {
        if (o == o2) {
            return true;
        }
        if (o == null || o2 == null) {
            return false;
        }
        if (o.getClass().isArray() && o2.getClass().isArray()) {
            boolean isPrimitive;
            Class<?> t1 = o.getClass().getComponentType();
            Class<?> t2 = o2.getClass().getComponentType();
            boolean bl = isPrimitive = t1.isPrimitive() && t2.isPrimitive();
            if (isPrimitive && t1.equals(t2)) {
                if (Boolean.TYPE.equals(t1)) {
                    return Arrays.equals((boolean[])o, (boolean[])o2);
                }
                if (Character.TYPE.equals(t1)) {
                    return Arrays.equals((char[])o, (char[])o2);
                }
                if (Byte.TYPE.equals(t1)) {
                    return Arrays.equals((byte[])o, (byte[])o2);
                }
                if (Short.TYPE.equals(t1)) {
                    return Arrays.equals((short[])o, (short[])o2);
                }
                if (Integer.TYPE.equals(t1)) {
                    return Arrays.equals((int[])o, (int[])o2);
                }
                if (Long.TYPE.equals(t1)) {
                    return Arrays.equals((long[])o, (long[])o2);
                }
                if (Float.TYPE.equals(t1)) {
                    return Arrays.equals((float[])o, (float[])o2);
                }
                if (Double.TYPE.equals(t1)) {
                    return Arrays.equals((double[])o, (double[])o2);
                }
            }
            if (!isPrimitive) {
                return Arrays.equals((Object[])o, (Object[])o2);
            }
            return false;
        }
        return o.equals(o2);
    }

    public static boolean isEqual(Comparable from, Comparable to) {
        return from.compareTo(to) == 0;
    }

    public static boolean isNotEqual(Comparable from, Comparable to) {
        return from.compareTo(to) != 0;
    }

    public static boolean isGreater(Comparable from, Comparable to) {
        return from.compareTo(to) > 0;
    }

    public static boolean isEqOrGreater(Comparable from, Comparable to) {
        return from.compareTo(to) >= 0;
    }

    public static boolean isLess(Comparable from, Comparable to) {
        return from.compareTo(to) < 0;
    }

    public static boolean isEqOrLess(Comparable from, Comparable to) {
        return from.compareTo(to) <= 0;
    }

    public static boolean isEnclose(CharSequence cs, char prefix, char suffix) {
        if (HEval.isEmpty(cs) || cs.length() < 2) {
            return false;
        }
        return prefix == cs.charAt(0) && suffix == cs.charAt(cs.length() - 1);
    }

    public static boolean isEnclose(CharSequence cs, CharSequence prefix, CharSequence suffix) {
        if (HEval.isEmpty(cs)) {
            return false;
        }
        int min = prefix.length() + suffix.length();
        if (cs.length() < min) {
            return false;
        }
        return HEval.prefix(cs, prefix) && HEval.suffix(cs, suffix);
    }

    public static boolean isStartsWith(CharSequence cs, CharSequence prefix, int offset) {
        if (HEval.isEmpty(cs)) {
            return false;
        }
        return HEval.startsWith(cs, prefix, offset);
    }

    public static boolean isSuffix(CharSequence cs, CharSequence suffix) {
        if (HEval.isEmpty(cs)) {
            return false;
        }
        return HEval.suffix(cs, suffix);
    }

    public static boolean isPrefix(CharSequence cs, CharSequence prefix) {
        if (HEval.isEmpty(cs)) {
            return false;
        }
        return HEval.prefix(cs, prefix);
    }

    static boolean suffix(CharSequence cs, CharSequence suffix) {
        int end = cs.length() - suffix.length();
        return HEval.startsWith(cs, suffix, end);
    }

    static boolean prefix(CharSequence cs, CharSequence prefix) {
        return HEval.startsWith(cs, prefix, 0);
    }

    static boolean startsWith(CharSequence cs, CharSequence prefix, int offset) {
        int plen = prefix.length();
        if (offset < 0 || offset > cs.length() - plen) {
            return false;
        }
        int to = offset;
        int po = 0;
        while (--plen >= 0) {
            if (cs.charAt(to++) == prefix.charAt(po++)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInstanceOf(Object o, Class clazz) {
        return clazz != null && clazz.isInstance(o);
    }

    public static boolean isEqualsClass(Object o, Class clazz) {
        return o != null && o.getClass().equals(clazz);
    }

    public static boolean isEqualsComponentType(Object a, Class clazz) {
        if (a == null) {
            return false;
        }
        Class<?> type = a.getClass();
        if (!type.isArray()) {
            throw new IllegalArgumentException("is not Array");
        }
        return type.getComponentType().equals(clazz);
    }

    public static boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    public static boolean isArrayClass(Class clazz) {
        return clazz != null && clazz.isArray();
    }

    public static boolean isEqualArraySize(Object[] array2d) {
        if (HEval.isEmpty(array2d)) {
            throw new IllegalArgumentException("array as empty");
        }
        int len = Array.getLength(array2d[0]);
        int i = 1;
        while (i < array2d.length) {
            if (len != Array.getLength(array2d[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isContains(boolean[] a, boolean e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(char[] a, char e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(byte[] a, byte e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(short[] a, short e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(int[] a, int e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(long[] a, long e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(float[] a, float e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(double[] a, double e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(Object[] a, Object o) {
        int i = 0;
        while (i < a.length) {
            if (HEval.isEquals(o, a[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(Collection coll, Object o) {
        if (coll == null) {
            return false;
        }
        return coll.contains(o);
    }

    public static boolean isContains(String source, char c) {
        if (source == null) {
            return false;
        }
        return source.indexOf(c) >= 0;
    }

    public static boolean isContains(String source, String target) {
        if (source == null) {
            return false;
        }
        return source.indexOf(target) >= 0;
    }

    public static boolean isContains(CharSequence cs, char c) {
        if (cs == null) {
            return false;
        }
        return HSeek.indexOf(cs, c, 1) >= 0;
    }

    public static boolean isContains(CharSequence cs, CharSequence target) {
        if (cs == null) {
            return false;
        }
        return HSeek.indexOf(cs, target, 1) >= 0;
    }

    public static boolean isIndex(CharSequence cs, int index) {
        return HEval.isIndex(cs.length(), index);
    }

    public static boolean isIndex(CharSequence cs, int min, int max) {
        return HEval.isIndex(cs.length(), min, max);
    }

    public static boolean isIndex(char[] a, int index) {
        return HEval.isIndex(a.length, index);
    }

    public static boolean isIndex(char[] a, int min, int max) {
        return HEval.isIndex(a.length, min, max);
    }

    public static boolean isIndex(boolean[] a, int index) {
        return HEval.isIndex(a.length, index);
    }

    public static boolean isIndex(boolean[] a, int min, int max) {
        return HEval.isIndex(a.length, min, max);
    }

    public static boolean isIndex(byte[] a, int index) {
        return HEval.isIndex(a.length, index);
    }

    public static boolean isIndex(byte[] a, int min, int max) {
        return HEval.isIndex(a.length, min, max);
    }

    public static boolean isIndex(short[] a, int index) {
        return HEval.isIndex(a.length, index);
    }

    public static boolean isIndex(short[] a, int min, int max) {
        return HEval.isIndex(a.length, min, max);
    }

    public static boolean isIndex(int[] a, int index) {
        return HEval.isIndex(a.length, index);
    }

    public static boolean isIndex(int[] a, int min, int max) {
        return HEval.isIndex(a.length, min, max);
    }

    public static boolean isIndex(long[] a, int index) {
        return HEval.isIndex(a.length, index);
    }

    public static boolean isIndex(long[] a, int min, int max) {
        return HEval.isIndex(a.length, min, max);
    }

    public static boolean isIndex(float[] a, int index) {
        return HEval.isIndex(a.length, index);
    }

    public static boolean isIndex(float[] a, int min, int max) {
        return HEval.isIndex(a.length, min, max);
    }

    public static boolean isIndex(double[] a, int index) {
        return HEval.isIndex(a.length, index);
    }

    public static boolean isIndex(double[] a, int min, int max) {
        return HEval.isIndex(a.length, min, max);
    }

    public static boolean isIndex(Object[] a, int index) {
        return HEval.isIndex(a.length, index);
    }

    public static boolean isIndex(Object[] a, int min, int max) {
        return HEval.isIndex(a.length, min, max);
    }

    public static boolean isIndex(int size, int index) {
        return index >= 0 && index < size;
    }

    public static boolean isIndex(int size, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("min > max (" + min + " > " + max + ")");
        }
        return min >= 0 && min < size && max >= 0 && max < size;
    }

    public static boolean isAndNull(Object o, Object o2) {
        return o == null && o2 == null;
    }

    public static boolean isAndNull(Object[] os) {
        int i = 0;
        while (i < os.length) {
            if (os[i] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOrNull(Object o, Object o2) {
        return o == null || o2 == null;
    }

    public static boolean isOrNull(Object o, Object o2, Object o3) {
        return o == null || o2 == null || o3 == null;
    }

    public static boolean isOrNull(Object o, Object o2, Object o3, Object o4) {
        return o == null || o2 == null || o3 == null || o4 == null;
    }

    public static boolean isOrNull(Object[] os) {
        int i = 0;
        while (i < os.length) {
            if (os[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isAndBlank(CharSequence cs, CharSequence cs2) {
        return HEval.isBlank(cs) && HEval.isBlank(cs2);
    }

    public static boolean isAndBlank(CharSequence cs, CharSequence cs2, CharSequence cs3) {
        return HEval.isBlank(cs) && HEval.isBlank(cs2) && HEval.isBlank(cs3);
    }

    public static boolean isAndBlank(CharSequence[] css) {
        int i = 0;
        while (i < css.length) {
            if (!HEval.isBlank(css[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOrBlank(CharSequence cs, CharSequence cs2) {
        return HEval.isBlank(cs) || HEval.isBlank(cs2);
    }

    public static boolean isOrBlank(CharSequence[] css) {
        int i = 0;
        while (i < css.length) {
            if (HEval.isBlank(css[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isAndEmpty(CharSequence cs, CharSequence cs2) {
        return HEval.isEmpty(cs) && HEval.isEmpty(cs2);
    }

    public static boolean isAndEmpty(CharSequence[] css) {
        int i = 0;
        while (i < css.length) {
            if (!HEval.isEmpty(css[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOrEmpty(CharSequence cs, CharSequence cs2) {
        return HEval.isEmpty(cs) || HEval.isEmpty(cs2);
    }

    public static boolean isOrEmpty(CharSequence[] css) {
        int i = 0;
        while (i < css.length) {
            if (HEval.isEmpty(css[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isOrEquals(Object o, Object o2, Object o3) {
        return HEval.isEquals(o, o2) || HEval.isEquals(o, o3);
    }

    public static boolean isOrEquals(Object o, Object o2, Object o3, Object o4) {
        return HEval.isEquals(o, o2) || HEval.isEquals(o, o3) || HEval.isEquals(o, o4);
    }

    public static boolean isOrStartsWith(CharSequence cs, CharSequence[] prefixs, int offset) {
        if (HEval.isEmpty(cs)) {
            return false;
        }
        int i = 0;
        while (i < prefixs.length) {
            if (HEval.startsWith(cs, prefixs[i], offset)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isOrSuffix(CharSequence cs, char[] suffixs) {
        if (HEval.isEmpty(cs)) {
            return false;
        }
        char suffix = cs.charAt(cs.length() - 1);
        int i = 0;
        while (i < suffixs.length) {
            if (suffix == suffixs[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isOrSuffix(CharSequence cs, CharSequence[] suffixs) {
        if (HEval.isEmpty(cs)) {
            return false;
        }
        int i = 0;
        while (i < suffixs.length) {
            if (HEval.suffix(cs, suffixs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isOrPrefix(CharSequence cs, char[] prefixs) {
        if (HEval.isEmpty(cs)) {
            return false;
        }
        char prefix = cs.charAt(0);
        int i = 0;
        while (i < prefixs.length) {
            if (prefix == prefixs[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isOrPrefix(CharSequence cs, CharSequence[] prefixs) {
        if (HEval.isEmpty(cs)) {
            return false;
        }
        int i = 0;
        while (i < prefixs.length) {
            if (HEval.prefix(cs, prefixs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isAndInstanceOf(Object o, Class clazz, Class clazz2) {
        return HEval.isInstanceOf(o, clazz) && HEval.isInstanceOf(o, clazz2);
    }

    public static boolean isAndInstanceOf(Object o, Class[] clazzes) {
        int i = 0;
        while (i < clazzes.length) {
            Class c = clazzes[i];
            if (!HEval.isInstanceOf(o, c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOrInstanceOf(Object o, Class clazz, Class clazz2) {
        return HEval.isInstanceOf(o, clazz) || HEval.isInstanceOf(o, clazz2);
    }

    public static boolean isOrInstanceOf(Object o, Class clazz, Class clazz2, Class clazz3) {
        return HEval.isInstanceOf(o, clazz) || HEval.isInstanceOf(o, clazz2) || HEval.isInstanceOf(o, clazz3);
    }

    public static boolean isOrInstanceOf(Object o, Class[] clazzes) {
        int i = 0;
        while (i < clazzes.length) {
            Class c = clazzes[i];
            if (HEval.isInstanceOf(o, c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isCharAt(CharSequence cs, int index, char c) {
        return index >= 0 && index < cs.length() && cs.charAt(index) == c;
    }
}

