/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import shohaku.core.helpers.BeanIntrospectDescriptor;
import shohaku.core.helpers.Constants;
import shohaku.core.helpers.HClass;
import shohaku.core.helpers.HCnv;
import shohaku.core.helpers.HEval;
import shohaku.core.helpers.HLog;
import shohaku.core.lang.IntrospectionBeansException;
import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.ObjectCreationProxy;

public class HBeans {
    public static final Class[] EMPTY_ARG_TYPES = Constants.EMPTY_CLASSES;
    public static final Object[] EMPTY_ARG_VALUES = Constants.EMPTY_OBJECTS;

    public static Collection getPropertyDescriptors(Class clazz) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getPropertyDescriptors();
    }

    public static Map getPropertyDescriptorMap(Class clazz) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getPropertyDescriptorMap();
    }

    public static PropertyDescriptor getPropertyDescriptor(Class clazz, String propName) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getPropertyDescriptor(propName);
    }

    public static IndexedPropertyDescriptor getIndexedPropertyDescriptor(Class clazz, String propName) throws IntrospectionBeansException {
        PropertyDescriptor pd = HBeans.getPropertyDescriptor(clazz, propName);
        if (pd instanceof IndexedPropertyDescriptor) {
            return (IndexedPropertyDescriptor)pd;
        }
        return null;
    }

    public static Method getAssignmentWriteProperty(Class clazz, String propName, Class[] paramTypes) throws IntrospectionBeansException {
        return HBeans.getAssignmentMethod(clazz, HBeans.getWritePropertyMethodName(propName), paramTypes);
    }

    public static Method getAssignmentReadProperty(Class clazz, String propName, Class[] paramTypes) throws IntrospectionBeansException {
        Method method = HBeans.getAssignmentMethod(clazz, HBeans.getReadPropertyMethodName(propName), paramTypes);
        if (method == null) {
            return HBeans.getAssignmentMethod(clazz, HBeans.getReadBooleanPropertyMethodName(propName), paramTypes);
        }
        return method;
    }

    public static Map getProperties(Object bean) throws IntrospectionBeansException {
        if (bean == null) {
            throw new NullPointerException("argument is null.");
        }
        Class<?> clazz = bean.getClass();
        String propName = null;
        try {
            Collection pds = HBeans.getPropertyDescriptors(clazz);
            HashMap<String, Object> props = new HashMap<String, Object>(pds.size());
            Iterator i = pds.iterator();
            while (i.hasNext()) {
                Method method;
                PropertyDescriptor pd = (PropertyDescriptor)i.next();
                propName = pd.getName();
                if ("class".equals(propName) || (method = pd.getReadMethod()) == null) continue;
                props.put(propName, method.invoke(bean, null));
            }
            return props;
        }
        catch (IllegalArgumentException e) {
            throw new IntrospectionBeansException(HLog.log("get property err. ", clazz, propName), e);
        }
        catch (IllegalAccessException e) {
            throw new IntrospectionBeansException(HLog.log("get property err. ", clazz, propName), e);
        }
        catch (InvocationTargetException e) {
            throw new IntrospectionBeansException(HLog.log("get property err. ", clazz, propName), e);
        }
    }

    public static Object setProperties(Object bean, Map props) throws IntrospectionBeansException {
        if (bean == null) {
            throw new NullPointerException("argument is null.");
        }
        Class<?> clazz = bean.getClass();
        String propName = null;
        Object propValue = null;
        try {
            Map propsDesc = HBeans.getPropertyDescriptorMap(clazz);
            Iterator i = props.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                propName = (String)e.getKey();
                propValue = e.getValue();
                PropertyDescriptor pd = (PropertyDescriptor)propsDesc.get(propName);
                if (pd == null) {
                    throw new IntrospectionBeansException(HLog.log("not find property. ", clazz, propName));
                }
                Method method = pd.getWriteMethod();
                if (method == null) {
                    throw new IntrospectionBeansException(HLog.log("property has no setter method. ", clazz, propName));
                }
                method.invoke(bean, HBeans.createParameterValues(new Object[]{propValue}));
            }
            return bean;
        }
        catch (ClassCastException e) {
            throw new IntrospectionBeansException(HLog.log("set property err. kay is not String. ", clazz, props), e);
        }
        catch (IllegalArgumentException e) {
            throw new IntrospectionBeansException(HLog.log("set property err. ", clazz, propName), e);
        }
        catch (IllegalAccessException e) {
            throw new IntrospectionBeansException(HLog.log("set property err. ", clazz, propName), e);
        }
        catch (InvocationTargetException e) {
            throw new IntrospectionBeansException(HLog.log("set property err. ", clazz, propName), e);
        }
    }

    public static Object getProperty(Object bean, String propName) throws IntrospectionBeansException {
        if (HEval.isOrNull(bean, propName)) {
            throw new NullPointerException("argument is null.");
        }
        Class<?> clazz = bean.getClass();
        PropertyDescriptor pd = HBeans.getPropertyDescriptor(clazz, propName);
        if (pd == null) {
            throw new IntrospectionBeansException(HLog.log("not find property. ", clazz, propName));
        }
        return HBeans.getProperty(bean, pd);
    }

    public static Object getProperty(Object bean, PropertyDescriptor pd) throws IntrospectionBeansException {
        if (HEval.isOrNull(bean, pd)) {
            throw new NullPointerException("argument is null.");
        }
        Class<?> clazz = bean.getClass();
        String propName = pd.getName();
        try {
            Method method = pd.getReadMethod();
            if (method == null) {
                throw new IntrospectionBeansException(HLog.log("property has no getter method. ", clazz, propName));
            }
            return method.invoke(bean, null);
        }
        catch (IllegalArgumentException e) {
            throw new IntrospectionBeansException(HLog.log("get property err. ", clazz, propName), e);
        }
        catch (IllegalAccessException e) {
            throw new IntrospectionBeansException(HLog.log("get property err. ", clazz, propName), e);
        }
        catch (InvocationTargetException e) {
            throw new IntrospectionBeansException(HLog.log("get property err. ", clazz, propName), e);
        }
    }

    public static Object getIndexedProperty(Object bean, String propName, Integer index) throws IntrospectionBeansException {
        if (HEval.isOrNull(bean, propName)) {
            throw new NullPointerException("argument is null.");
        }
        Class<?> clazz = bean.getClass();
        IndexedPropertyDescriptor ipd = HBeans.getIndexedPropertyDescriptor(clazz, propName);
        if (ipd == null) {
            throw new IntrospectionBeansException(HLog.log("not find indexed property. ", clazz, propName));
        }
        return HBeans.getIndexedProperty(bean, ipd, index);
    }

    public static Object getIndexedProperty(Object bean, IndexedPropertyDescriptor ipd, Integer index) throws IntrospectionBeansException {
        if (HEval.isOrNull(bean, ipd)) {
            throw new NullPointerException("argument is null.");
        }
        Class<?> clazz = bean.getClass();
        String propName = ipd.getName();
        try {
            Method method = ipd.getIndexedReadMethod();
            if (method == null) {
                throw new IntrospectionBeansException(HLog.log("property has no getter indexed method. ", clazz, propName, index));
            }
            return method.invoke(bean, index);
        }
        catch (IllegalArgumentException e) {
            throw new IntrospectionBeansException(HLog.log("get indexed property err. ", clazz, propName, index), e);
        }
        catch (IllegalAccessException e) {
            throw new IntrospectionBeansException(HLog.log("get indexed property err. ", clazz, propName, index), e);
        }
        catch (InvocationTargetException e) {
            throw new IntrospectionBeansException(HLog.log("get indexed property err. ", clazz, propName, index), e);
        }
    }

    public static void setProperty(Object bean, String propName, Object newValue) throws IntrospectionBeansException {
        if (HEval.isOrNull(bean, propName)) {
            throw new NullPointerException("argument is null.");
        }
        Class<?> clazz = bean.getClass();
        PropertyDescriptor pd = HBeans.getPropertyDescriptor(clazz, propName);
        if (pd == null) {
            throw new IntrospectionBeansException(HLog.log("not find property. ", clazz, propName));
        }
        HBeans.setProperty(bean, pd, newValue);
    }

    public static void setProperty(Object bean, PropertyDescriptor pd, Object newValue) throws IntrospectionBeansException {
        if (HEval.isOrNull(bean, pd)) {
            throw new NullPointerException("argument is null.");
        }
        Class<?> clazz = bean.getClass();
        String propName = pd.getName();
        try {
            Method method = pd.getWriteMethod();
            if (method == null) {
                throw new IntrospectionBeansException(HLog.log("property has no setter method. ", clazz, propName));
            }
            method.invoke(bean, newValue);
        }
        catch (IllegalArgumentException e) {
            throw new IntrospectionBeansException(HLog.log("set property err. ", clazz, propName, newValue), e);
        }
        catch (IllegalAccessException e) {
            throw new IntrospectionBeansException(HLog.log("set property err. ", clazz, propName, newValue), e);
        }
        catch (InvocationTargetException e) {
            throw new IntrospectionBeansException(HLog.log("set property err. ", clazz, propName, newValue), e);
        }
    }

    public static void setIndexedProperty(Object bean, String propName, Integer index, Object newValue) throws IntrospectionBeansException {
        if (HEval.isOrNull(bean, propName)) {
            throw new NullPointerException("argument is null.");
        }
        Class<?> clazz = bean.getClass();
        IndexedPropertyDescriptor ipd = HBeans.getIndexedPropertyDescriptor(clazz, propName);
        if (ipd == null) {
            throw new IntrospectionBeansException(HLog.log("not find indexed property. ", clazz, propName, index));
        }
        HBeans.setIndexedProperty(bean, ipd, index, newValue);
    }

    public static void setIndexedProperty(Object bean, IndexedPropertyDescriptor ipd, Integer index, Object newValue) throws IntrospectionBeansException {
        if (HEval.isOrNull(bean, ipd)) {
            throw new NullPointerException("argument is null.");
        }
        Class<?> clazz = bean.getClass();
        String propName = ipd.getName();
        try {
            Method method = ipd.getIndexedWriteMethod();
            if (method == null) {
                throw new IntrospectionBeansException(HLog.log("property has no setter indexed method. ", clazz, propName, index, newValue));
            }
            method.invoke(bean, index, newValue);
        }
        catch (IllegalArgumentException e) {
            throw new IntrospectionBeansException(HLog.log("set property err. ", clazz, propName, index, newValue), e);
        }
        catch (IllegalAccessException e) {
            throw new IntrospectionBeansException(HLog.log("set property err. ", clazz, propName, index, newValue), e);
        }
        catch (InvocationTargetException e) {
            throw new IntrospectionBeansException(HLog.log("set property err. ", clazz, propName, index, newValue), e);
        }
    }

    public static boolean containsProperty(Class clazz, String prefix, String propName) throws IntrospectionBeansException {
        return HBeans.containsMethod(clazz, HBeans.propertyAsMethodName(prefix, propName));
    }

    public static Map getMethodGroup(Class clazz) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getMethodGroup();
    }

    public static Collection getMethods(Class clazz, String methodName) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getMethods(methodName);
    }

    public static Method getMethod(Class clazz, String methodName) throws IntrospectionBeansException {
        return HBeans.getMethod(clazz, methodName, EMPTY_ARG_TYPES);
    }

    public static Method getMethod(Class clazz, String methodName, Class[] paramTypes) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getMethod(methodName, paramTypes);
    }

    public static Method getAssignmentMethod(Class clazz, String methodName, Class[] paramTypes) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getAssignmentMethod(methodName, paramTypes);
    }

    public static boolean containsMethod(Class clazz, String methodName) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getMethods(methodName) != null;
    }

    public static Map getAccessibleMethodGroup(Class clazz) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getAccessibleMethodGroup();
    }

    public static Collection getAccessibleMethods(Class clazz, String methodName) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getAccessibleMethods(methodName);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName) throws IntrospectionBeansException {
        return HBeans.getAccessibleMethod(clazz, methodName, EMPTY_ARG_TYPES);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName, Class[] paramTypes) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getAccessibleMethod(methodName, paramTypes);
    }

    public static Method getAssignmentAccessibleMethod(Class clazz, String methodName, Class[] paramTypes) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getAssignmentAccessibleMethod(methodName, paramTypes);
    }

    public static boolean containsAccessibleMethod(Class clazz, String methodName) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getAccessibleMethods(methodName) != null;
    }

    public static Object invokeMethod(Object obj, Method method, Object paramValue) throws IntrospectionBeansException {
        return HBeans.invokeMethod(obj, method, new Object[]{paramValue});
    }

    public static Object invokeMethod(Object obj, Method method, Object[] paramValues) throws IntrospectionBeansException {
        if (HEval.isOrNull(method, paramValues)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            if (HBeans.isStatic(method)) {
                return method.invoke(null, HBeans.createParameterValues(paramValues));
            }
            if (obj == null) {
                throw new NullPointerException("argument obj is null.");
            }
            return method.invoke(obj, HBeans.createParameterValues(paramValues));
        }
        catch (IllegalArgumentException e) {
            throw new IntrospectionBeansException(HLog.log("method invocation err. ", method, paramValues), e);
        }
        catch (IllegalAccessException e) {
            throw new IntrospectionBeansException(HLog.log("method invocation err. ", method, paramValues), e);
        }
        catch (InvocationTargetException e) {
            throw new IntrospectionBeansException(HLog.log("method invocation err. ", method, paramValues), e);
        }
    }

    public static Map getFieldGroup(Class clazz) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getFieldGroup();
    }

    public static Collection getFields(Class clazz, String fieldName) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getFields(fieldName);
    }

    public static Field getField(Class clazz, String fieldName) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getField(fieldName);
    }

    public static boolean containsField(Class clazz, String fieldName) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getFields(fieldName) != null;
    }

    public static Object getFieldValue(Class clazz, Object obj, String fieldName) throws IntrospectionBeansException {
        try {
            return HBeans.getField(clazz, fieldName).get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new IntrospectionBeansException(HLog.log("get field err. ", clazz, fieldName), e);
        }
        catch (IllegalAccessException e) {
            throw new IntrospectionBeansException(HLog.log("get field err. ", clazz, fieldName), e);
        }
    }

    public static Object setFieldValue(Class clazz, Object obj, String fieldName, Object newValue) throws IntrospectionBeansException {
        try {
            Field field = HBeans.getField(clazz, fieldName);
            Object oldValue = field.get(obj);
            field.set(obj, newValue);
            return oldValue;
        }
        catch (IllegalArgumentException e) {
            throw new IntrospectionBeansException(HLog.log("set field err. ", clazz, fieldName, newValue), e);
        }
        catch (IllegalAccessException e) {
            throw new IntrospectionBeansException(HLog.log("set field err. ", clazz, fieldName, newValue), e);
        }
    }

    public static Map getAccessibleFieldGroup(Class clazz) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getAccessibleFieldGroup();
    }

    public static Collection getAccessibleFields(Class clazz, String fieldName) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getAccessibleFields(fieldName);
    }

    public static Field getAccessibleField(Class clazz, String fieldName) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getAccessibleField(fieldName);
    }

    public static boolean containsAccessibleField(Class clazz, String fieldName) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getAccessibleFields(fieldName) != null;
    }

    public static Object getAccessibleFieldValue(Class clazz, Object obj, String fieldName) throws IntrospectionBeansException {
        try {
            return HBeans.getAccessibleField(clazz, fieldName).get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new IntrospectionBeansException(HLog.log("get field err. ", clazz, fieldName), e);
        }
        catch (IllegalAccessException e) {
            throw new IntrospectionBeansException(HLog.log("get field err. ", clazz, fieldName), e);
        }
    }

    public static Object setAccessibleFieldValue(Class clazz, Object obj, String fieldName, Object newValue) throws IntrospectionBeansException {
        try {
            Field field = HBeans.getAccessibleField(clazz, fieldName);
            Object oldValue = field.get(obj);
            field.set(obj, newValue);
            return oldValue;
        }
        catch (IllegalArgumentException e) {
            throw new IntrospectionBeansException(HLog.log("set field err. ", clazz, fieldName, newValue), e);
        }
        catch (IllegalAccessException e) {
            throw new IntrospectionBeansException(HLog.log("set field err. ", clazz, fieldName, newValue), e);
        }
    }

    public static Map getConstantFieldMap(Class clazz) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getConstantFieldMap();
    }

    public static Object getConstantFieldValue(Class clazz, String fieldName) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getConstantField(fieldName);
    }

    public static Collection getConstructors(Class clazz) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getConstructors();
    }

    public static Constructor getConstructor(Class clazz) throws IntrospectionBeansException {
        return HBeans.getConstructor(clazz, EMPTY_ARG_TYPES);
    }

    public static Constructor getConstructor(Class clazz, Class[] paramTypes) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getConstructor(paramTypes);
    }

    public static Constructor getAssignmentConstructor(Class clazz, Class[] paramTypes) throws IntrospectionBeansException {
        return HBeans.getBeanDescriptor(clazz).getAssignmentConstructor(paramTypes);
    }

    public static Object newInstance(Class clazz) throws IntrospectionBeansException {
        return HBeans.newInstance(clazz, EMPTY_ARG_TYPES, EMPTY_ARG_VALUES);
    }

    public static Object newInstance(Class clazz, Object[] paramValues) throws IntrospectionBeansException {
        return HBeans.newInstance(clazz, HBeans.toClassArray(paramValues), paramValues);
    }

    public static Object newInstance(Class clazz, Class[] paramTypes, Object[] paramValues) throws IntrospectionBeansException {
        try {
            return HBeans.getAssignmentConstructor(clazz, paramTypes).newInstance(HBeans.createParameterValues(paramValues));
        }
        catch (SecurityException e) {
            throw new IntrospectionBeansException(HLog.log("new instance err. ", clazz, paramTypes, paramValues), e);
        }
        catch (IllegalArgumentException e) {
            throw new IntrospectionBeansException(HLog.log("new instance err. ", clazz, paramTypes, paramValues), e);
        }
        catch (InstantiationException e) {
            throw new IntrospectionBeansException(HLog.log("new instance err. ", clazz, paramTypes, paramValues), e);
        }
        catch (IllegalAccessException e) {
            throw new IntrospectionBeansException(HLog.log("new instance err. ", clazz, paramTypes, paramValues), e);
        }
        catch (InvocationTargetException e) {
            throw new IntrospectionBeansException(HLog.log("new instance err. ", clazz, paramTypes, paramValues), e);
        }
    }

    public static boolean isAssignmentCompatible(Class[] fromTypes, Class[] toTypes) {
        if (fromTypes.length != toTypes.length) {
            return false;
        }
        int i = 0;
        while (i < fromTypes.length) {
            if (!HBeans.isAssignmentCompatible(fromTypes[i], toTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAssignmentCompatible(Class fromType, Class toType) {
        if (fromType.isAssignableFrom(toType)) {
            return true;
        }
        return HClass.boxEquals(fromType, toType);
    }

    public static Class[] toClassArray(Object[] objects) {
        Class[] cs = new Class[objects.length];
        int i = 0;
        while (i < objects.length) {
            cs[i] = objects[i].getClass();
            ++i;
        }
        return cs;
    }

    public static String propertyAsMethodName(String prefix, String propName) {
        return String.valueOf(prefix) + HCnv.capitalize(propName);
    }

    static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    static BeanIntrospectDescriptor getBeanDescriptor(Class clazz) throws IntrospectionBeansException {
        return BeanIntrospectDescriptor.forClass(clazz);
    }

    static Object[] createParameterValues(Object[] srcValues) throws IntrospectionBeansException {
        Object[] newValues;
        try {
            newValues = new Object[srcValues.length];
            int i = 0;
            while (i < srcValues.length) {
                Object o = srcValues[i];
                if (o instanceof ObjectCreationProxy) {
                    o = ((ObjectCreationProxy)o).create();
                }
                newValues[i] = o;
                ++i;
            }
        }
        catch (ObjectCreationException e) {
            if (e.getCause() instanceof IntrospectionBeansException) {
                throw (IntrospectionBeansException)e.getCause();
            }
            throw new IntrospectionBeansException(HLog.log("creat parameters err. ", srcValues), e);
        }
        return newValues;
    }

    static String getReadPropertyMethodName(String propName) {
        return HBeans.getPropertyMethodName("get", propName);
    }

    static String getReadBooleanPropertyMethodName(String propName) {
        return HBeans.getPropertyMethodName("is", propName);
    }

    static String getWritePropertyMethodName(String propName) {
        return HBeans.getPropertyMethodName("set", propName);
    }

    static String getPropertyMethodName(String prefix, String propName) {
        if (HEval.isEmpty(propName)) {
            return prefix;
        }
        char[] chars = propName.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return prefix + chars;
    }
}

