/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections.cache;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import shohaku.core.collections.Cache;
import shohaku.core.functor.FFactory;

public abstract class AbstractCache
implements Cache {
    final Object mutex;
    final Map map;
    int maximumSize;
    FFactory factory;
    transient Collection values = null;
    transient Set keySet = null;
    transient Set entrySet = null;

    protected AbstractCache(Map t, int maxSize, Cache initCache) {
        this.map = t;
        this.maximumSize = maxSize;
        this.mutex = this;
        if (initCache != null) {
            this.putAll(initCache);
        }
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxSize() {
        Object object = this.mutex;
        synchronized (object) {
            return this.maximumSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int maxSize) {
        Object object = this.mutex;
        synchronized (object) {
            this.maximumSize = maxSize;
            if (maxSize >= 0) {
                this.resize(maxSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLimit() {
        Object object = this.mutex;
        synchronized (object) {
            return this.maximumSize >= 0 && this.maximumSize <= this.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("size is a negative number. " + newSize);
        }
        Object object = this.mutex;
        synchronized (object) {
            block6: {
                int _size = this.size();
                if (newSize >= _size) break block6;
                Iterator i = this.map.entrySet().iterator();
                while (i.hasNext()) {
                    i.next();
                    i.remove();
                    if (newSize == --_size) break;
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        Object object = this.mutex;
        synchronized (object) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.factory == null) {
                return this.map.get(key);
            }
            if (!this.map.containsKey(key)) {
                Object o = this.factory.create(key);
                this.put(key, o);
                return o;
            }
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FFactory getFactory() {
        Object object = this.mutex;
        synchronized (object) {
            return this.factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFactory(FFactory factory) {
        Object object = this.mutex;
        synchronized (object) {
            this.factory = factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.map.containsKey(key) && this.isLimit()) {
                this.resize(this.size() - 1);
            }
            return this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Cache t) {
        Object object = this.mutex;
        synchronized (object) {
            Iterator i = t.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map t) {
        Object object = this.mutex;
        synchronized (object) {
            Iterator i = t.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        Object object = this.mutex;
        synchronized (object) {
            return this.values != null ? this.values : (this.values = new Values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        Object object = this.mutex;
        synchronized (object) {
            return this.keySet != null ? this.keySet : (this.keySet = new KeySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        Object object = this.mutex;
        synchronized (object) {
            return this.entrySet != null ? this.entrySet : (this.entrySet = new EntrySet());
        }
    }

    protected Map getSourceMap() {
        return this.map;
    }

    class Values
    extends AbstractView {
        Values() {
            super(AbstractCache.this.map.values());
        }
    }

    class KeySet
    extends AbstractView
    implements Set {
        KeySet() {
            super(AbstractCache.this.map.keySet());
        }
    }

    class EntrySet
    extends AbstractView
    implements Set {
        EntrySet() {
            super(AbstractCache.this.map.entrySet());
        }
    }

    abstract class AbstractView
    implements Collection {
        private final Collection src;

        AbstractView(Collection c) {
            this.src = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator iterator() {
            Object object = AbstractCache.this.mutex;
            synchronized (object) {
                return this.src.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = AbstractCache.this.mutex;
            synchronized (object) {
                return this.src.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = AbstractCache.this.mutex;
            synchronized (object) {
                return this.src.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object o) {
            Object object = AbstractCache.this.mutex;
            synchronized (object) {
                return this.src.contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection c) {
            Object object = AbstractCache.this.mutex;
            synchronized (object) {
                return this.src.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o) {
            Object object = AbstractCache.this.mutex;
            synchronized (object) {
                return this.src.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection c) {
            Object object = AbstractCache.this.mutex;
            synchronized (object) {
                return this.src.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection c) {
            Object object = AbstractCache.this.mutex;
            synchronized (object) {
                return this.src.retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = AbstractCache.this.mutex;
            synchronized (object) {
                this.src.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Object object = AbstractCache.this.mutex;
            synchronized (object) {
                return this.src.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] a) {
            Object object = AbstractCache.this.mutex;
            synchronized (object) {
                return this.src.toArray(a);
            }
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }
    }
}

