/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import shohaku.core.collections.MapBox;
import shohaku.core.helpers.HEval;
import shohaku.core.helpers.HHash;

public class MapBoxUtils {
    public static MapBox mapBox(Object key, Object value) {
        return new ObjectMapBox(key, value);
    }

    public static MapBox arrayMapBox(Object[] key, Object value) {
        return new ObjectArrayMapBox(key, value);
    }

    public static MapBox identityMapBox(Object key, Object value) {
        return new IdentityMapBox(key, value);
    }

    public static MapBox identityArrayMapBox(Object[] key, Object value) {
        return new IdentityObjectArrayMapBox(key, value);
    }

    public static MapBox arrayMapBox(byte[] key, Object value) {
        return new ByteArrayMapBox(key, value);
    }

    public static MapBox arrayMapBox(short[] key, Object value) {
        return new ShortArrayMapBox(key, value);
    }

    public static MapBox arrayMapBox(int[] key, Object value) {
        return new IntArrayMapBox(key, value);
    }

    public static MapBox arrayMapBox(long[] key, Object value) {
        return new LongArrayMapBox(key, value);
    }

    public static MapBox arrayMapBox(float[] key, Object value) {
        return new FloatArrayMapBox(key, value);
    }

    public static MapBox arrayMapBox(double[] key, Object value) {
        return new DoubleArrayMapBox(key, value);
    }

    public static MapBox arrayMapBox(boolean[] key, Object value) {
        return new BooleanArrayMapBox(key, value);
    }

    static class ObjectMapBox
    implements MapBox {
        private final Object key;
        private Object value;

        ObjectMapBox(Object k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object setValue(Object v) {
            this.value = v;
            return this.value;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof MapBox)) {
                return false;
            }
            MapBox e = (MapBox)o;
            Object v = e.getKey();
            return HEval.isEquals(this.key, v);
        }
    }

    static class ObjectArrayMapBox
    implements MapBox {
        private final Object[] key;
        private Object value;

        ObjectArrayMapBox(Object[] k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object setValue(Object v) {
            this.value = v;
            return this.value;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof MapBox)) {
                return false;
            }
            MapBox e = (MapBox)o;
            Object v = e.getKey();
            if (this.key == v) {
                return true;
            }
            if (v == null || !(v instanceof Object[])) {
                return false;
            }
            Object[] a = (Object[])v;
            return HEval.isEquals(this.key, a);
        }
    }

    static class IdentityMapBox
    implements MapBox {
        private final Object key;
        private Object value;

        IdentityMapBox(Object k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object setValue(Object v) {
            this.value = v;
            return this.value;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return System.identityHashCode(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof MapBox)) {
                return false;
            }
            MapBox e = (MapBox)o;
            Object v = e.getKey();
            return this.key == v;
        }
    }

    static class IdentityObjectArrayMapBox
    implements MapBox {
        private final Object[] key;
        private Object value;

        IdentityObjectArrayMapBox(Object[] k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object setValue(Object v) {
            this.value = v;
            return this.value;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.identityHash(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof MapBox)) {
                return false;
            }
            MapBox e = (MapBox)o;
            Object v = e.getKey();
            if (this.key == v) {
                return true;
            }
            if (v == null || !(v instanceof Object[])) {
                return false;
            }
            Object[] a = (Object[])v;
            return HEval.isEqualsIdentity(this.key, a);
        }
    }

    static class ByteArrayMapBox
    implements MapBox {
        private final byte[] key;
        private Object value;

        ByteArrayMapBox(byte[] k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object setValue(Object v) {
            this.value = v;
            return this.value;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof MapBox)) {
                return false;
            }
            MapBox e = (MapBox)o;
            Object v = e.getKey();
            if (this.key == v) {
                return true;
            }
            if (v == null || !(v instanceof byte[])) {
                return false;
            }
            byte[] a = (byte[])v;
            return HEval.isEquals(this.key, a);
        }
    }

    static class ShortArrayMapBox
    implements MapBox {
        private final short[] key;
        private Object value;

        ShortArrayMapBox(short[] k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object setValue(Object v) {
            this.value = v;
            return this.value;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof MapBox)) {
                return false;
            }
            MapBox e = (MapBox)o;
            Object v = e.getKey();
            if (this.key == v) {
                return true;
            }
            if (v == null || !(v instanceof short[])) {
                return false;
            }
            short[] a = (short[])v;
            return HEval.isEquals(this.key, a);
        }
    }

    static class IntArrayMapBox
    implements MapBox {
        private final int[] key;
        private Object value;

        IntArrayMapBox(int[] k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object setValue(Object v) {
            this.value = v;
            return this.value;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof MapBox)) {
                return false;
            }
            MapBox e = (MapBox)o;
            Object v = e.getKey();
            if (this.key == v) {
                return true;
            }
            if (v == null || !(v instanceof int[])) {
                return false;
            }
            int[] a = (int[])v;
            return HEval.isEquals(this.key, a);
        }
    }

    static class LongArrayMapBox
    implements MapBox {
        private final long[] key;
        private Object value;

        LongArrayMapBox(long[] k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object setValue(Object v) {
            this.value = v;
            return this.value;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof MapBox)) {
                return false;
            }
            MapBox e = (MapBox)o;
            Object v = e.getKey();
            if (this.key == v) {
                return true;
            }
            if (v == null || !(v instanceof long[])) {
                return false;
            }
            long[] a = (long[])v;
            return HEval.isEquals(this.key, a);
        }
    }

    static class FloatArrayMapBox
    implements MapBox {
        private final float[] key;
        private Object value;

        FloatArrayMapBox(float[] k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object setValue(Object v) {
            this.value = v;
            return this.value;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof MapBox)) {
                return false;
            }
            MapBox e = (MapBox)o;
            Object v = e.getKey();
            if (this.key == v) {
                return true;
            }
            if (v == null || !(v instanceof float[])) {
                return false;
            }
            float[] a = (float[])v;
            return HEval.isEquals(this.key, a);
        }
    }

    static class DoubleArrayMapBox
    implements MapBox {
        private final double[] key;
        private Object value;

        DoubleArrayMapBox(double[] k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object setValue(Object v) {
            this.value = v;
            return this.value;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof MapBox)) {
                return false;
            }
            MapBox e = (MapBox)o;
            Object v = e.getKey();
            if (this.key == v) {
                return true;
            }
            if (v == null || !(v instanceof double[])) {
                return false;
            }
            double[] a = (double[])v;
            return HEval.isEquals(this.key, a);
        }
    }

    static class BooleanArrayMapBox
    implements MapBox {
        private final boolean[] key;
        private Object value;

        BooleanArrayMapBox(boolean[] k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object setValue(Object v) {
            this.value = v;
            return this.value;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof MapBox)) {
                return false;
            }
            MapBox e = (MapBox)o;
            Object v = e.getKey();
            if (this.key == v) {
                return true;
            }
            if (v == null || !(v instanceof boolean[])) {
                return false;
            }
            boolean[] a = (boolean[])v;
            return HEval.isEquals(this.key, a);
        }
    }
}

