/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import shohaku.core.collections.decorator.DecoratedList;
import shohaku.core.collections.decorator.DecoratedRandomAccessList;
import shohaku.core.lang.Predicate;

public class ListUtils {
    public static List unextendsList(List list) {
        if (list instanceof RandomAccess) {
            return new DecoratedRandomAccessList(list);
        }
        return new DecoratedList(list);
    }

    public static List addAll(List list, Iterator elements) {
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    public static List addAll(List list, int index, Iterator elements) {
        int i = index;
        while (elements.hasNext()) {
            list.add(i++, elements.next());
        }
        return list;
    }

    public static List addAll(List list, int index, Iterator elements, Predicate predicate) {
        int i = index;
        while (elements.hasNext()) {
            Object o = elements.next();
            if (!predicate.evaluate(o)) continue;
            list.add(i++, elements.next());
        }
        return list;
    }

    public static List addAll(List list, int index, Collection elements, Predicate predicate) {
        return ListUtils.addAll(list, index, elements.iterator(), predicate);
    }
}

