/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import shohaku.core.collections.decorator.DecoratedListIterator;
import shohaku.core.collections.decorator.UnmodifiableListIterator;

public class ListIteratorUtils {
    public static ListIterator emptyListIterator() {
        return new EmptyListIterator();
    }

    public static ListIterator unmodifiableListIterator(ListIterator listiterator) {
        return new UnmodifiableListIterator(listiterator);
    }

    public static ListIterator unextendsListIterator(ListIterator listiterator) {
        return new DecoratedListIterator(listiterator);
    }

    static class EmptyListIterator
    implements ListIterator {
        EmptyListIterator() {
        }

        public int nextIndex() {
            return -1;
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public int previousIndex() {
            return -1;
        }

        public boolean hasPrevious() {
            return false;
        }

        public Object previous() {
            throw new NoSuchElementException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

