/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import shohaku.core.collections.decorator.DecoratedIterator;
import shohaku.core.collections.decorator.UnmodifiableIterator;
import shohaku.core.helpers.HEval;
import shohaku.core.lang.Boxing;
import shohaku.core.lang.Predicate;

public class IteratorUtils {
    public static Iterator compositeIterator(Iterator[] is) {
        return new CompositeIterator(is);
    }

    public static Iterator emptyIterator() {
        return new EmptyIterator();
    }

    public static Iterator infiniteLoopIterator() {
        return new InfiniteLoopIterator(null);
    }

    public static Iterator infiniteLoopIterator(Object infiniteValue) {
        return new InfiniteLoopIterator(infiniteValue);
    }

    public static Iterator arrayIterator(Object a) {
        if (a == null) {
            throw new NullPointerException();
        }
        if (HEval.isArray(a)) {
            Class<?> type = a.getClass().getComponentType();
            if (type.isPrimitive()) {
                if (type == Character.TYPE) {
                    return IteratorUtils.asIterator((char[])a);
                }
                if (type == Boolean.TYPE) {
                    return IteratorUtils.asIterator((boolean[])a);
                }
                if (type == Byte.TYPE) {
                    return IteratorUtils.asIterator((byte[])a);
                }
                if (type == Short.TYPE) {
                    return IteratorUtils.asIterator((short[])a);
                }
                if (type == Integer.TYPE) {
                    return IteratorUtils.asIterator((int[])a);
                }
                if (type == Long.TYPE) {
                    return IteratorUtils.asIterator((long[])a);
                }
                if (type == Float.TYPE) {
                    return IteratorUtils.asIterator((float[])a);
                }
                if (type == Double.TYPE) {
                    return IteratorUtils.asIterator((double[])a);
                }
            } else {
                return IteratorUtils.asIterator((Object[])a);
            }
        }
        throw new IllegalArgumentException("is not Array:" + a);
    }

    public static Iterator asIterator(CharSequence cs) {
        return new CharSequenceIterator(cs);
    }

    public static Iterator asIterator(Object[] a) {
        return new ObjectArrayIterator(a);
    }

    public static Iterator asIterator(char[] a) {
        return new CharacterArrayIterator(a);
    }

    public static Iterator asIterator(boolean[] a) {
        return new BooleanArrayIterator(a);
    }

    public static Iterator asIterator(byte[] a) {
        return new ByteArrayIterator(a);
    }

    public static Iterator asIterator(short[] a) {
        return new ShortArrayIterator(a);
    }

    public static Iterator asIterator(int[] a) {
        return new IntegerArrayIterator(a);
    }

    public static Iterator asIterator(long[] a) {
        return new LongArrayIterator(a);
    }

    public static Iterator asIterator(float[] a) {
        return new FloatArrayIterator(a);
    }

    public static Iterator asIterator(double[] a) {
        return new DoubleArrayIterator(a);
    }

    public static Iterator asIterator(Enumeration a) {
        return new EnumerationIteratorAdapter(a);
    }

    public static Iterator predicateIterator(Iterator i, Predicate predicate) {
        return new PredicateIterator(i, predicate);
    }

    public static Iterator unmodifiableIterator(Iterator i) {
        return new UnmodifiableIterator(i);
    }

    public static Iterator unextendsIterator(Iterator i) {
        return new DecoratedIterator(i);
    }

    public static Iterator collectionIterator(Object collection) {
        Iterator i;
        if (HEval.isArray(collection)) {
            i = IteratorUtils.arrayIterator(collection);
        } else if (collection instanceof Collection) {
            i = ((Collection)collection).iterator();
        } else if (collection instanceof Iterator) {
            i = (Iterator)collection;
        } else if (collection instanceof Map) {
            i = ((Map)collection).entrySet().iterator();
        } else if (collection instanceof CharSequence) {
            i = IteratorUtils.asIterator((CharSequence)collection);
        } else if (collection instanceof Enumeration) {
            i = IteratorUtils.asIterator((Enumeration)collection);
        } else {
            throw new IllegalArgumentException("is not collection type. " + collection);
        }
        return i;
    }

    public static Iterator shift(Iterator i, int skipCount) {
        int count = 0;
        while (skipCount > count && i.hasNext()) {
            i.next();
            ++count;
        }
        return i;
    }

    static class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    }

    static class InfiniteLoopIterator
    implements Iterator {
        private final Object v;

        InfiniteLoopIterator(Object infiniteValue) {
            this.v = infiniteValue;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return true;
        }

        public Object next() {
            return this.v;
        }
    }

    static class EnumerationIteratorAdapter
    implements Iterator {
        private final Enumeration e;

        EnumerationIteratorAdapter(Enumeration e) {
            this.e = e;
        }

        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        public Object next() {
            if (!this.e.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.e.nextElement();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static abstract class AbstractArrayIterator
    implements Iterator {
        protected final int length;
        protected int index = -1;

        AbstractArrayIterator(Object a) {
            if (a == null) {
                throw new NullPointerException();
            }
            this.length = Array.getLength(a);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.index + 1 < this.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextObject(++this.index);
        }

        protected abstract Object nextObject(int var1);
    }

    static class ObjectArrayIterator
    extends AbstractArrayIterator {
        private final Object[] a;

        ObjectArrayIterator(Object[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return this.a[inx];
        }
    }

    static class CharacterArrayIterator
    extends AbstractArrayIterator {
        private final char[] a;

        CharacterArrayIterator(char[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    static class BooleanArrayIterator
    extends AbstractArrayIterator {
        private final boolean[] a;

        BooleanArrayIterator(boolean[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    static class ByteArrayIterator
    extends AbstractArrayIterator {
        private final byte[] a;

        ByteArrayIterator(byte[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    static class ShortArrayIterator
    extends AbstractArrayIterator {
        private final short[] a;

        ShortArrayIterator(short[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    static class IntegerArrayIterator
    extends AbstractArrayIterator {
        private final int[] a;

        IntegerArrayIterator(int[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    static class LongArrayIterator
    extends AbstractArrayIterator {
        private final long[] a;

        LongArrayIterator(long[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    static class FloatArrayIterator
    extends AbstractArrayIterator {
        private final float[] a;

        FloatArrayIterator(float[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    static class DoubleArrayIterator
    extends AbstractArrayIterator {
        private final double[] a;

        DoubleArrayIterator(double[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    static class CharSequenceIterator
    implements Iterator {
        private final CharSequence chars;
        private int index = -1;

        CharSequenceIterator(CharSequence cs) {
            if (cs == null) {
                throw new NullPointerException();
            }
            this.chars = cs;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.index + 1 < this.chars.length();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return Boxing.box(this.chars.charAt(++this.index));
        }
    }

    static class CompositeIterator
    implements Iterator {
        final Iterator[] iters;
        private Iterator i;
        private int index = -1;

        CompositeIterator(Iterator[] is) {
            this.iters = is;
        }

        public void remove() {
            if (this.i == null) {
                throw new IllegalStateException();
            }
            this.i.remove();
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean hasNext() {
            if (this.i == null) {
                if (this.index + 1 >= this.iters.length) {
                    return false;
                }
                this.i = this.iters[++this.index];
            }
            while (!this.i.hasNext()) {
                if (this.index + 1 >= this.iters.length) {
                    return false;
                }
                this.i = this.iters[++this.index];
            }
            return true;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.i.next();
        }
    }

    static abstract class FilterIterator
    implements Iterator {
        private final Object NULL;
        private final Iterator i;
        private Object next;
        private Boolean hasNext;

        FilterIterator(Iterator iter) {
            this.next = this.NULL = new Object();
            this.hasNext = null;
            this.i = iter;
        }

        public void remove() {
            if (this.next == this.NULL) {
                throw new IllegalStateException();
            }
            this.i.remove();
        }

        public boolean hasNext() {
            if (this.hasNext != null) {
                return this.hasNext;
            }
            this.hasNext = Boolean.FALSE;
            while (this.i.hasNext()) {
                Object e = this.i.next();
                if (!this.accept(e)) continue;
                this.next = e;
                this.hasNext = Boolean.TRUE;
                break;
            }
            return this.hasNext;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNext = null;
            return this.next;
        }

        abstract boolean accept(Object var1);
    }

    static class PredicateIterator
    extends FilterIterator {
        private final Predicate predicate;

        PredicateIterator(Iterator iter, Predicate predicate) {
            super(iter);
            this.predicate = predicate;
        }

        boolean accept(Object e) {
            return this.predicate.evaluate(e);
        }
    }
}

