/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class ComparatorUtils {
    public static Comparator nullComparator(boolean nullLess) {
        final boolean comparableNullLess = nullLess;
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return ComparatorUtils.compare((Comparable)o1, (Comparable)o2, comparableNullLess);
            }
        };
    }

    public static int compare(Comparable comp, Comparable comp2, boolean nullLess) {
        if (comp == null && comp2 == null) {
            return 0;
        }
        if (comp == null) {
            return nullLess ? -1 : 1;
        }
        if (comp2 == null) {
            return nullLess ? 1 : -1;
        }
        return comp.compareTo(comp2);
    }

    public static int compare(Object o, Object o2, Comparator comp, boolean nullLess) {
        if (o == null && o2 == null) {
            return 0;
        }
        if (o == null) {
            return nullLess ? -1 : 1;
        }
        if (o2 == null) {
            return nullLess ? 1 : -1;
        }
        return comp.compare(o, o2);
    }

    public static int compare(Collection comps, Collection comps2, boolean nullLess) {
        if (comps == null && comps2 == null) {
            return 0;
        }
        if (comps == null) {
            return nullLess ? -1 : 1;
        }
        if (comps2 == null) {
            return nullLess ? 1 : -1;
        }
        if (comps.size() != comps2.size()) {
            return comps.size() > comps2.size() ? 1 : -1;
        }
        Iterator i = comps.iterator();
        Iterator i2 = comps2.iterator();
        while (i.hasNext() || i2.hasNext()) {
            if (!i.hasNext()) {
                return -1;
            }
            if (!i2.hasNext()) {
                return 1;
            }
            int r = ComparatorUtils.compare((Comparable)i.next(), (Comparable)i2.next(), nullLess);
            if (r == 0) continue;
            return r > 0 ? 1 : -1;
        }
        return 0;
    }

    public static int compare(Collection coll, Collection coll2, Comparator comp, boolean nullLess) {
        if (coll == null && coll2 == null) {
            return 0;
        }
        if (coll == null) {
            return nullLess ? -1 : 1;
        }
        if (coll2 == null) {
            return nullLess ? 1 : -1;
        }
        if (coll.size() != coll2.size()) {
            return coll.size() > coll2.size() ? 1 : -1;
        }
        Iterator i = coll.iterator();
        Iterator i2 = coll2.iterator();
        while (i.hasNext() || i2.hasNext()) {
            if (!i.hasNext()) {
                return -1;
            }
            if (!i2.hasNext()) {
                return 1;
            }
            int r = ComparatorUtils.compare(i.next(), i2.next(), comp, nullLess);
            if (r == 0) continue;
            return r > 0 ? 1 : -1;
        }
        return 0;
    }
}

