/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import shohaku.core.collections.decorator.DecoratedCollection;
import shohaku.core.lang.Predicate;

public class CollectionsUtils {
    public static Collection unextendsCollection(Collection coll) {
        return new DecoratedCollection(coll);
    }

    public static Object toArray(Collection coll, Class type) {
        Object a = Array.newInstance(type, coll.size());
        int i = 0;
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            Array.set(a, i++, iter.next());
        }
        return a;
    }

    public static Collection addAll(Collection coll, Iterator elements) {
        while (elements.hasNext()) {
            coll.add(elements.next());
        }
        return coll;
    }

    public static Collection addAll(Collection coll, Iterator elements, Predicate predicate) {
        while (elements.hasNext()) {
            Object o = elements.next();
            if (!predicate.evaluate(o)) continue;
            coll.add(o);
        }
        return coll;
    }

    public static Collection addAll(Collection coll, Collection elements, Predicate predicate) {
        return CollectionsUtils.addAll(coll, elements.iterator(), predicate);
    }

    public static Collection retainAll(Collection coll, Predicate predicate) {
        Iterator i = coll.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!predicate.evaluate(o)) continue;
            i.remove();
        }
        return coll;
    }
}

