/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.beans.binder;

import java.lang.reflect.Method;
import java.util.Map;
import shohaku.core.beans.binder.BindArgumentRule;
import shohaku.core.beans.binder.BindArgumentsDesc;
import shohaku.core.helpers.HBeans;
import shohaku.core.helpers.HEval;
import shohaku.core.helpers.HLog;
import shohaku.core.lang.IntrospectionBeansException;

public class BindMethod {
    private Class objectType;
    private Object srcObject;
    private Method method;
    private String methodName;
    private BindArgumentsDesc bindArgumentsDesc;
    private Class[] parameterTypes;
    private Object[] parameterValues;
    private String[] parameterNames;
    private BindArgumentRule[] parameterRules;
    private String _toString;

    private BindMethod(Class objectType, Object srcObject, String methodName, BindArgumentsDesc args) throws IntrospectionBeansException {
        this.methodName = methodName;
        this.objectType = objectType;
        this.srcObject = srcObject;
        this.bindArgumentsDesc = args;
        this.parameterTypes = args.getArgumentTypes();
        this.parameterRules = args.getArgumentRules();
        this.parameterNames = args.getArgumentNames();
        this.parameterValues = args.getArgumentValues();
        this.init();
    }

    public Object invoke(Map values) throws IntrospectionBeansException {
        return this.invokeMethod(this.getSrcObject(), this.getMethod(), values);
    }

    public Class getObjectType() {
        return this.objectType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object getSrcObject() {
        return this.srcObject;
    }

    public Method getMethod() {
        return this.method;
    }

    public BindArgumentsDesc getBindArgumentsDesc() {
        return this.bindArgumentsDesc;
    }

    public String toString() {
        return this._toString;
    }

    private void init() throws IntrospectionBeansException {
        Class[] types = this.parameterTypes;
        Object[] values = this.parameterValues;
        CharSequence[] names = this.parameterNames;
        BindArgumentRule[] rules = this.parameterRules;
        if (!HEval.isEqualArraySize(new Object[]{types, values, names, rules})) {
            throw new IntrospectionBeansException("parameter is illegal.");
        }
        if (HEval.isOrEmpty(names)) {
            throw new IntrospectionBeansException("parameter is illegal.");
        }
        try {
            this.initMethod(this.getMatchingAccessibleMethod());
        }
        catch (NoSuchMethodException e) {
            throw new IntrospectionBeansException("parameter is illegal.", e);
        }
        this.buildToString();
    }

    private void initMethod(Method initMethod) {
        this.method = initMethod;
    }

    private Object invokeMethod(Object obj, Method invokeMethod, Map params) throws IntrospectionBeansException {
        Object[] values = (Object[])this.parameterValues.clone();
        String[] names = this.parameterNames;
        BindArgumentRule[] rules = this.parameterRules;
        int i = 0;
        while (i < values.length) {
            BindArgumentRule rule = rules[i];
            String name = names[i];
            if (BindArgumentRule.FINAL == rule) {
                if (params.containsKey(name)) {
                    throw new IntrospectionBeansException("illegal parameter name is final. " + name);
                }
            } else if (BindArgumentRule.OVERWRITE == rule) {
                if (params.containsKey(name)) {
                    values[i] = params.get(name);
                }
            } else if (BindArgumentRule.REQUIRED == rule) {
                if (params.containsKey(name)) {
                    values[i] = params.get(name);
                } else {
                    throw new IntrospectionBeansException("required parameter isn't included. " + name);
                }
            }
            ++i;
        }
        return HBeans.invokeMethod(obj, invokeMethod, values);
    }

    private Method getMatchingAccessibleMethod() throws NoSuchMethodException, IntrospectionBeansException {
        Method m = HBeans.getAssignmentMethod(this.getObjectType(), this.getMethodName(), this.parameterTypes);
        if (m == null) {
            throw new NoSuchMethodException(HLog.log("not find Method. ", this.getObjectType(), this.getMethodName(), this.parameterTypes));
        }
        return m;
    }

    private void buildToString() {
        Class[] types = this.parameterTypes;
        Object[] values = this.parameterValues;
        String[] names = this.parameterNames;
        BindArgumentRule[] rules = this.parameterRules;
        StringBuffer sb = new StringBuffer();
        sb.append("bind method=");
        sb.append(this.getMethod());
        sb.append('{');
        int i = 0;
        while (i < types.length) {
            sb.append('{');
            sb.append(rules[i]);
            sb.append(',');
            sb.append(names[i]);
            sb.append(',');
            sb.append(values[i]);
            sb.append('}');
            ++i;
        }
        sb.append('}');
        this._toString = sb.toString();
    }

    public static BindMethod bind(Class objectType, Object srcObject, String methodName, BindArgumentsDesc args) throws IntrospectionBeansException {
        return new BindMethod(objectType, srcObject, methodName, args);
    }
}

