/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.lang.feature.impl;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import shohaku.core.lang.feature.LogFeature;

/**
 * org.apache.log4j API を出力先とするログ機能を提供します。
 */
class Log4JLogFeature implements LogFeature {

    private final Logger log;

    /**
     * log4j ログのインスタンスを格納して初期化します。
     * 
     * @param logger
     *            log4j ログ
     */
    public Log4JLogFeature(Logger logger) {
        this.log = logger;
    }

    public boolean isTraceEnabled() {
        return log.isEnabledFor(Level.TRACE);
    }

    public boolean isDebugEnabled() {
        return log.isEnabledFor(Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return log.isEnabledFor(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return log.isEnabledFor(Level.WARN);
    }

    public boolean isErrorEnabled() {
        return log.isEnabledFor(Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return log.isEnabledFor(Level.FATAL);
    }

    public void trace(Object message) {
        log.trace(message);
    }

    public void trace(Object message, Throwable t) {
        log.trace(message, t);
    }

    public void debug(Object message) {
        log.debug(message);
    }

    public void debug(Object message, Throwable t) {
        log.debug(message, t);
    }

    public void info(Object message) {
        log.info(message);
    }

    public void info(Object message, Throwable t) {
        log.info(message, t);
    }

    public void warn(Object message) {
        log.warn(message);
    }

    public void warn(Object message, Throwable t) {
        log.warn(message, t);
    }

    public void error(Object message) {
        log.error(message);
    }

    public void error(Object message, Throwable t) {
        log.error(message, t);
    }

    public void fatal(Object message) {
        log.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        log.fatal(message, t);
    }

}
