/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.lang.feature.impl;

import shohaku.core.util.debug.Dump;

/**
 * shohaku.core.util.debug.Dump を出力先とするログ機能を提供します。
 */
class DebugLogFeature extends ConsoleLogFeature {

    /**
     * ログの名前を指定して初期化します。
     * 
     * @param name
     *            ログの名前
     */
    public DebugLogFeature(String name) {
        super(name);
    }

    protected void write(int type, StringBuffer buffer) {
        if (type > ConsoleLogFeature.LOG_LEVEL_INFO) {
            // WARN, ERROR, FATAL : error
            Dump.err.println(buffer.toString());
        } else {
            // TRACE, DEBUG, INFO : output
            Dump.out.println(buffer.toString());
        }
    }

}
