/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.lang.feature;

/**
 * ログ機能を定義します。
 */
public interface LogFeature {

    /*
     * 出力レベル
     */

    /**
     * レベルが有効か判定します。
     * 
     * @return レベルが有効の場合は true
     */
    boolean isTraceEnabled();

    /**
     * レベルが有効か判定します。
     * 
     * @return レベルが有効の場合は true
     */
    boolean isDebugEnabled();

    /**
     * レベルが有効か判定します。
     * 
     * @return レベルが有効の場合は true
     */
    boolean isInfoEnabled();

    /**
     * レベルが有効か判定します。
     * 
     * @return レベルが有効の場合は true
     */
    boolean isWarnEnabled();

    /**
     * レベルが有効か判定します。
     * 
     * @return レベルが有効の場合は true
     */
    boolean isErrorEnabled();

    /**
     * レベルが有効か判定します。
     * 
     * @return レベルが有効の場合は true
     */
    boolean isFatalEnabled();

    /*
     * 出力メソッド
     */

    /**
     * ログを出力します。
     * 
     * @param message
     *            ログメッセージ
     */
    void trace(Object message);

    /**
     * ログを出力します。
     * 
     * @param message
     *            ログメッセージ
     * @param t
     *            ログの起因
     */
    void trace(Object message, Throwable t);

    /**
     * ログを出力します。
     * 
     * @param message
     *            ログメッセージ
     */
    void debug(Object message);

    /**
     * ログを出力します。
     * 
     * @param message
     *            ログメッセージ
     * @param t
     *            ログの起因
     */
    void debug(Object message, Throwable t);

    /**
     * ログを出力します。
     * 
     * @param message
     *            ログメッセージ
     */
    void info(Object message);

    /**
     * ログを出力します。
     * 
     * @param message
     *            ログメッセージ
     * @param t
     *            ログの起因
     */
    void info(Object message, Throwable t);

    /**
     * ログを出力します。
     * 
     * @param message
     *            ログメッセージ
     */
    void warn(Object message);

    /**
     * ログを出力します。
     * 
     * @param message
     *            ログメッセージ
     * @param t
     *            ログの起因
     */
    void warn(Object message, Throwable t);

    /**
     * ログを出力します。
     * 
     * @param message
     *            ログメッセージ
     */
    void error(Object message);

    /**
     * ログを出力します。
     * 
     * @param message
     *            ログメッセージ
     * @param t
     *            ログの起因
     */
    void error(Object message, Throwable t);

    /**
     * ログを出力します。
     * 
     * @param message
     *            ログメッセージ
     */
    void fatal(Object message);

    /**
     * ログを出力します。
     * 
     * @param message
     *            ログメッセージ
     * @param t
     *            ログの起因
     */
    void fatal(Object message, Throwable t);

}
