/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.lang;

/**
 * オブジェクトインスタンスを生成するプロキシを示すインタフェースを提供します。<br>
 * このインターフェースと連携する処理では、実装クラスに対してインスタンスではなく生成された値を処理の対象とします。
 */
public interface ObjectCreationProxy {

    /**
     * 生成されるオブジェクト型を返却します。
     * 
     * @return 生成するオブジェクト型
     */
    Class getInstanceType();

    /**
     * インスタンスを生成して返却します。
     * 
     * @return 生成されたインスタンス
     * @throws ObjectCreationException
     *             オブジェクトの生成に失敗した場合
     */
    Object create() throws ObjectCreationException;

    /**
     * インスタンスを破棄する処理を実行します。
     * 
     * @param o
     *            破棄するインスタンス
     * @throws ObjectDestructionException
     *             オブジェクトの破棄に失敗した場合
     */
    void destroy(Object o) throws ObjectDestructionException;

}
