/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.collections.decorator;

import java.util.List;
import java.util.RandomAccess;

/**
 * 指定されたランダムアクセスをサポートするリストを装飾するビューを提供します。 <br>
 * <br>
 * このクラスはランダムアクセスリストの実装を隠蔽する目的や、装飾クラスの基底実装の役割を持ちます。<br>
 * 装飾されたリストが直列化可能の場合は直列化可能です。
 */
public class DecoratedRandomAccessList extends DecoratedList implements RandomAccess {

    /* serialVersionUID */
    private static final long serialVersionUID = 621019257733907478L;

    /**
     * ラップするランダムアクセスリストを指定して初期化します。
     * 
     * @param list
     *            ラップするランダムアクセスリスト
     * @throws IllegalArgumentException
     *             引数が RandomAccess を実装していない場合
     */
    public DecoratedRandomAccessList(List list) {
        super(list);
        if (!(list instanceof RandomAccess)) {
            throw new IllegalArgumentException("not implements RandomAccess. " + list.getClass());
        }
    }

    /**
     * 基となるリストの同メソッドの戻り値を DecoratedRandomAccessList で装飾したランダムアクセスリストを返却します。
     * 
     * @see java.util.List#subList(int, int)
     */
    public List subList(int fromIndex, int toIndex) {
        return new DecoratedRandomAccessList(list.subList(fromIndex, toIndex));
    }

}
