/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.collections.decorator;

import java.io.Serializable;
import java.util.Map;

/**
 * 指定されたマップエントリを装飾するビューを提供します。 <br>
 * <br>
 * このクラスはマップエントリの実装を隠蔽する目的や、装飾クラスの基底実装の役割を持ちます。<br>
 * 装飾されたマップエントリが直列化可能の場合は直列化可能です。
 */
public class DecoratedMapEntry implements Map.Entry, Serializable {

    /* serialVersionUID */
    private static final long serialVersionUID = -1034040327472834519L;

    /** ラップするマップエントリ */
    protected Map.Entry e;

    /**
     * ラップするマップエントリを指定して初期化します。
     * 
     * @param e
     *            ラップするマップエントリ
     */
    public DecoratedMapEntry(Map.Entry e) {
        this.e = e;
    }

    public Object getKey() {
        return e.getKey();
    }

    public Object getValue() {
        return e.getValue();
    }

    public Object setValue(Object value) {
        return e.setValue(value);
    }

    public int hashCode() {
        return e.hashCode();
    }

    public boolean equals(Object o) {
        return e.equals(o);
    }

    public String toString() {
        return e.toString();
    }
}