/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.collections;

import java.util.Iterator;
import java.util.Set;

import shohaku.core.collections.decorator.DecoratedSet;

/**
 * Set インタフェースのユーティリティメソッドを提供します。
 */
public class SetUtils {

    /**
     * 実装型に固有の機能へのアクセスを制限したセットを返却します。
     * 
     * @param set
     *            ラップするセット
     * @return 実装を装飾したセット
     */
    public static Set unextendsSet(Set set) {
        return new DecoratedSet(set);
    }

    /**
     * セットに反復子の要素を全て追加します。
     * 
     * @param s
     *            追加先のセット
     * @param elements
     *            追加する反復子
     * @return 引数のセット参照
     */
    public static Set addAll(Set s, Iterator elements) {
        while (elements.hasNext()) {
            s.add(elements.next());
        }
        return s;
    }

}
