/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.beans.dynamic;

import shohaku.core.lang.IntrospectionBeansException;
import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.ObjectDestructionException;

/**
 * 要求ごとにインスタンスを生成するファクトリを提供します。
 */
public class PrototypeBeanFactory implements BeanFactory {

    /* クラス情報。 */
    private ClassDesc classDesc;

    /* 生成基のオブジェクト型。 */
    private Class createSource;

    /**
     * null プロパティで初期化します。
     */
    public PrototypeBeanFactory() {
        super();
    }

    /**
     * クラス情報を格納します。
     * 
     * @param classDesc
     *            クラス情報
     */
    public void setClassDesc(ClassDesc classDesc) {
        this.classDesc = classDesc;
    }

    /**
     * 生成基のオブジェクト型を格納します。
     * 
     * @param createSource
     *            生成基のオブジェクト型
     */
    public void setCreateSource(Class createSource) {
        this.createSource = createSource;
    }

    public ClassDesc getClassDesc() {
        return classDesc;
    }

    public Class getCreateSource() {
        return createSource;
    }

    public Class getInstanceType() {
        return Object.class;
    }

    public Object create() throws ObjectCreationException {
        try {
            return getClassDesc().createInstance(getCreateSource());
        } catch (IntrospectionBeansException e) {
            throw new ObjectCreationException("error create prototype Instance. ClassDesc=" + getClassDesc(), e);
        }
    }

    public void destroy(Object o) throws ObjectDestructionException {
        try {
            getClassDesc().destroyInstance(o);
        } catch (IntrospectionBeansException e) {
            throw new ObjectDestructionException("error destroy prototype Instance. ClassDesc=" + getClassDesc(), e);
        }
    }

}
