/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.beans.binder;

/**
 * 更新規則と名前で拘束された引数情報を格納する機能を提供します。
 */
public class BindArgumentDesc {

    /* 引数の型。 */
    private final Class type;

    /* 引数の値。 */
    private final Object value;

    /* 引数拘束名。 */
    private final String bindName;

    /* 引数拘束ルール。 */
    private final BindArgumentRule bindRule;

    /**
     * 引数のプロパティを格納して初期化します。
     * 
     * @param type
     *            引数の型
     * @param value
     *            引数の値
     * @param bindName
     *            拘束名
     * @param bindRule
     *            拘束ルール
     */
    public BindArgumentDesc(Class type, Object value, String bindName, BindArgumentRule bindRule) {
        this.type = type;
        this.value = value;
        this.bindName = bindName;
        this.bindRule = bindRule;
    }

    /*
     * Property
     */

    /**
     * 引数の型を返却します。
     * 
     * @return 引数の型
     */
    public Class getType() {
        return type;
    }

    /**
     * 引数の値を返却します。
     * 
     * @return 引数の値
     */
    public Object getValue() {
        return value;
    }

    /**
     * 拘束名返却します．
     * 
     * @return 拘束名
     */
    public String getBindName() {
        return bindName;
    }

    /**
     * 拘束ルールを返却します．
     * 
     * @return 拘束ルール
     */
    public BindArgumentRule getBindRule() {
        return bindRule;
    }

}
