/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.ginkgo.nodes.core.collection;

import java.util.Collection;
import java.util.List;

import shohaku.core.collections.group.GroupUtils;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.nodes.AbstractValueNode;

/**
 * キーと値集合の要素が一つのみ持つグループを生成するノードを提供します。
 */
public class SingletonGroupNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        List args = getContext().getValueElementChildren();
        if (args.size() != 2) {
            throw new GinkgoException("entry except for two are specified. size:" + args.size());
        }
        Object key = ((Node) args.get(0)).getNodeValue();
        Object value = ((Node) args.get(1)).getNodeValue();
        if (value.getClass().isArray()) {
            return GroupUtils.singletonGroup(key, (Object[]) value);
        } else if (value instanceof Collection) {
            return GroupUtils.singletonGroup(key, (Collection) value);
        } else {
            throw new GinkgoException("element is illegal. Array or Collection is right. value:" + value);
        }

    }

}
