/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.nodes.core.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

import shohaku.core.collections.params.Parameters;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.nodes.AbstractValueNode;

/**
 * <code>Parameters</code>型のデータを生成する値型のノードを提供します。
 */
public class ParametersNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        ArrayList initValues = new ArrayList();
        try {
            for (Iterator i = getContext().valueElementIterator(); i.hasNext();) {
                Map entry = (Map) ((Node) i.next()).getNodeValue();
                for (Iterator j = entry.entrySet().iterator(); j.hasNext();) {
                    Map.Entry e = (Map.Entry) j.next();
                    initValues.add(e.getKey());
                    initValues.add(e.getValue());
                }
            }
        } catch (ClassCastException e) {
            throw new GinkgoException("element except for Map is illegal.");
        }

        return new Parameters(initValues);

    }

}