/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.ginkgo.nodes.core.collection;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;

import shohaku.core.helpers.Eval;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.nodes.AbstractValueNode;

/**
 * 配列型のデータを生成する値型のノードを提供します。
 */
public class ArrayNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        Class type = getFeature().getAttributeToClass(this, "type", Object.class);
        if (!Eval.isArrayClass(type)) {
            throw new GinkgoException("no Array class:" + type);
        }

        List args = getContext().getValueElementChildren();

        Object array = Array.newInstance(type.getComponentType(), args.size());
        int index = 0;
        for (Iterator i = args.iterator(); i.hasNext();) {
            Array.set(array, index, ((Node) i.next()).getNodeValue());
            index++;
        }

        return array;
    }
}
