/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.ginkgo.nodes.core.beans;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import shohaku.core.beans.ArgumentInfo;
import shohaku.core.beans.ArgumentsInfo;
import shohaku.core.beans.FactoryMethodInfo;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.nodes.AbstractValueNode;

/**
 * <code>shohaku.core.beans.FactoryMethodInfo</code>型のデータを生成する値型のノードを提供します。
 */
public class FactoryMethodInfoNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        FactoryMethodInfo factory = null;

        List params = new ArrayList();
        for (Iterator i = getContext().valueElementIterator(); i.hasNext();) {
            Object o = ((Node) i.next()).getNodeValue();
            if (!(o instanceof ArgumentInfo)) {
                throw new GinkgoException("element is illegal. ArgumentInfo is right. value:" + o);
            }
            params.add(o);
        }
        ArgumentInfo[] parameters = (ArgumentInfo[]) params.toArray(new ArgumentInfo[0]);
        String methodName = getAttribute("method");
        if (methodName != null && methodName.length() != 0) {
            Class type = getFeature().getAttributeToClass(this, "class", null);
            if (type != null) {
                factory = new FactoryMethodInfo(methodName, new ArgumentsInfo(parameters), type);
            } else {
                factory = new FactoryMethodInfo(methodName, new ArgumentsInfo(parameters));
            }
        } else {
            factory = new FactoryMethodInfo(new ArgumentsInfo(parameters));
        }

        return factory;
    }
}