/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.nodes.core.beans;

import java.util.ArrayList;
import java.util.Iterator;

import shohaku.core.beans.BindArgumentInfo;
import shohaku.core.beans.BindArgumentsInfo;
import shohaku.core.beans.BindMethod;
import shohaku.core.beans.BindMethodBuilder;
import shohaku.core.beans.InvocationBeansException;
import shohaku.core.helpers.Eval;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.nodes.AbstractValueNode;

/**
 * <code>shohaku.core.beans.BindMethod</code>型のデータを生成する値型のノードを提供します。
 */
public class BindMethodNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        // BindMethodBuilder
        BindMethodBuilder builder = new BindMethodBuilder();

        String methodName = getAttribute("name");
        if (Eval.isBlank(methodName)) {
            throw new GinkgoException("不正なメソッド名です。");
        }
        Class type = null;
        Object object = null;
        type = getFeature().getAttributeToClass(this, "class");
        if (null == type) {
            Object ref = getFeature().getAttributeRef(this, "ref");
            if (null == ref) {
                throw new GinkgoException("reference id doesn't exist.");
            }
            if (ref instanceof Class) {
                type = (Class) ref;
                object = null;
            } else {
                type = ref.getClass();
                object = ref;
            }
        }

        ArrayList l = new ArrayList();
        for (Iterator i = getContext().valueElementIterator(); i.hasNext();) {
            Object e = ((Node) i.next()).getNodeValue();
            if (e instanceof BindArgumentInfo) {
                l.add(e);
            }
        }
        BindArgumentInfo[] bindArguments = (BindArgumentInfo[]) l.toArray(new BindArgumentInfo[0]);
        builder.setMethod(type, object, methodName, new BindArgumentsInfo(bindArguments));

        // generate BindMethod
        BindMethod bindMethod;
        try {
            bindMethod = builder.bind();
        } catch (InvocationBeansException e) {
            throw new GinkgoException(e);
        }
        return bindMethod;
    }

}
