/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.ginkgo.nodes.core.beans;

import java.util.List;

import shohaku.core.beans.ArgumentInfo;
import shohaku.core.beans.ObjectGenerator;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.nodes.AbstractValueNode;

/**
 * <code>shohaku.core.beans.ArgumentInfo</code>型のデータを生成する値型のノードを提供します。
 */
public class ArgumentInfoNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        Object value = null;
        if (getContext().isElementEmpty()) {
            // empty element, text to CEL value
            value = getFeature().getCELValue(this, getText());
        } else {
            // not empty element, node value
            List args = getContext().getValueElementChildren();
            if (args.size() != 1) {
                throw new GinkgoException("entry except for one are specified size:" + args.size());
            }
            value = ((Node) args.get(0)).getNodeValue();
        }
        // get argument type
        Class type = getFeature().getAttributeToClass(this, "type");
        if (type == null) {
            if (value == null) {
                type = Object.class;
            } else if (value instanceof ObjectGenerator) {
                type = ((ObjectGenerator) value).getInstanceType();
            } else {
                type = value.getClass();
            }
        }
        // generate ArgumentInfo
        return new ArgumentInfo(type, value);

    }

}
