/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.cel;

import shohaku.core.util.cel.CELBinder;
import shohaku.core.util.cel.CELContext;
import shohaku.core.util.cel.CELExpression;
import shohaku.core.util.cel.CELFormatException;
import shohaku.core.util.cel.CELLiteral;
import shohaku.core.util.cel.CELReturnValue;
import shohaku.core.util.cel.CELUtils;

public class ReferenceExpression
implements CELExpression {
    private static final CELLiteral literal = new CELLiteral('^', '^');

    public CELLiteral getLiteral() {
        return literal;
    }

    public CELReturnValue execute(CELBinder binder, String expression, int beginIndex, CELContext context) {
        int nextIndex = CELUtils.findNextIndex(expression, beginIndex, ReferenceExpression.literal.end);
        if (-1 == nextIndex) {
            throw new CELFormatException("format err :" + expression);
        }
        String refid = expression.substring(beginIndex + 1, nextIndex - 1).replaceAll("\\^", "^");
        if (!context.containsName(refid)) {
            throw new CELFormatException("not contains reference id:" + refid);
        }
        Object o = context.getValue(refid);
        return new CELReturnValue(o, nextIndex);
    }
}

