/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import shohaku.core.helpers.Eval;
import shohaku.core.util.XResourceBundleIterator;

public abstract class XResourceBundle {
    protected final Map lookupMap;
    protected final Set lookupKeys;
    protected final XResourceBundle parent;
    protected final Object bundleBase;

    protected XResourceBundle(XResourceBundle parent, Object bundleBase, Map resources) {
        this.parent = parent;
        this.bundleBase = bundleBase;
        this.lookupMap = resources;
        this.lookupKeys = this.lookupMap.keySet();
    }

    protected Object getBundleBase() {
        return this.bundleBase;
    }

    public Iterator keyIterator() {
        Iterator parentIterator = this.parent != null ? this.parent.keyIterator() : null;
        return new XResourceBundleIterator(this.lookupKeys, parentIterator);
    }

    public Object getObject(String key) {
        if (key == null) {
            throw new NullPointerException("resource key as null");
        }
        Object obj = this.lookupMap.get(key);
        if (obj == null && this.parent != null) {
            obj = this.parent.getObject(key);
        }
        return obj;
    }

    public Object getObject(String key, Object defaultValue) {
        if (this.containsKey(key)) {
            return this.getObject(key);
        }
        return defaultValue;
    }

    public boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException("resource key as null");
        }
        if (!this.lookupMap.containsKey(key)) {
            if (this.parent != null) {
                return this.lookupMap.containsKey(key);
            }
            return false;
        }
        return true;
    }

    public boolean containsKey(String key, Class type) {
        if (Eval.isOrNull(key, type)) {
            throw new NullPointerException("resource key or type as null");
        }
        if (this.containsKey(key)) {
            Object o = this.getObject(key);
            if (o != null) {
                return type.isInstance(o);
            }
            return true;
        }
        return false;
    }
}

