/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import shohaku.core.helpers.Eval;

public class DateUtils {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Date parse(String text) {
        return DateUtils.parse(text, DEFAULT_DATE_FORMAT, false, true);
    }

    public static Date parse(String text, String pattern) {
        return DateUtils.parse(text, pattern, false, true);
    }

    public static Date parse(String text, String pattern, boolean strict) {
        return DateUtils.parse(text, pattern, false, strict);
    }

    private static Date parse(String text, String pattern, boolean lenient, boolean strict) {
        try {
            if (strict && pattern.length() != text.length()) {
                return null;
            }
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            format.setLenient(lenient);
            return format.parse(text);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parse(String text, String[] patterns) {
        return DateUtils.parse(text, patterns, false, true);
    }

    public static Date parse(String text, String[] patterns, boolean strict) {
        return DateUtils.parse(text, patterns, false, strict);
    }

    private static Date parse(String text, String[] patterns, boolean lenient, boolean strict) {
        SimpleDateFormat format = new SimpleDateFormat();
        format.setLenient(lenient);
        int textLen = text.length();
        Date d = null;
        int i = 0;
        while (i < patterns.length) {
            if (!strict || patterns[i].length() == textLen) {
                format.applyPattern(patterns[i]);
                try {
                    d = format.parse(text);
                    break;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return d;
    }

    public static String format(Object date) {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (Eval.isOrInstance(date, clazz2, clazz)) {
            return DateUtils.format(Locale.getDefault(), date, DEFAULT_DATE_FORMAT);
        }
        throw new IllegalArgumentException("argument o is not Date or Calendar :" + date);
    }

    public static String format(Object date, String pattern) {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (Eval.isOrInstance(date, clazz2, clazz)) {
            return DateUtils.format(Locale.getDefault(), date, pattern);
        }
        throw new IllegalArgumentException("argument o is not Date or Calendar :" + date);
    }

    public static String format(Locale locale, Object date, String pattern) {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Eval.isOrInstance(date, clazz2, clazz)) {
            throw new IllegalArgumentException("argument o is not Date or Calendar :" + date);
        }
        if (date instanceof Calendar) {
            date = ((Calendar)date).getTime();
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, locale);
        return formatter.format(date);
    }

    public static String format(Locale locale, Object date, int style) {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Eval.isOrInstance(date, clazz2, clazz)) {
            throw new IllegalArgumentException("argument o is not Date or Calendar :" + date);
        }
        if (date instanceof Calendar) {
            date = ((Calendar)date).getTime();
        }
        DateFormat formatter = DateFormat.getDateInstance(style, locale);
        return formatter.format(date);
    }

    public static boolean isDate(CharSequence date, String pattern) {
        return DateUtils.isDate(date, pattern, Locale.getDefault());
    }

    public static boolean isDate(CharSequence date, String pattern, Locale locale) {
        if (date == null) {
            return false;
        }
        String sdate = date.toString();
        if (pattern.length() != sdate.length()) {
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, new DateFormatSymbols(locale));
        format.setLenient(false);
        try {
            format.parse(sdate);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static boolean isDate(CharSequence date, String[] patterns) {
        return DateUtils.isDate(date, patterns, Locale.getDefault());
    }

    public static boolean isDate(CharSequence date, String[] patterns, Locale locale) {
        if (date == null) {
            return false;
        }
        String sdate = date.toString();
        SimpleDateFormat format = new SimpleDateFormat();
        format.setDateFormatSymbols(new DateFormatSymbols(locale));
        format.setLenient(false);
        int i = 0;
        while (i < patterns.length) {
            String ptrn = patterns[i];
            if (ptrn.length() == sdate.length()) {
                format.applyPattern(ptrn);
                try {
                    format.parse(sdate);
                    return true;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return false;
    }
}

