/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import shohaku.core.helpers.Eval;

public class Seek {
    public static int skip(CharSequence cs, char c, int fromIndex) {
        int inx = fromIndex;
        while (inx < cs.length()) {
            if (cs.charAt(inx) != c) break;
            ++inx;
        }
        return inx;
    }

    public static int skipSp(CharSequence cs, int fromIndex) {
        int inx = fromIndex;
        while (inx < cs.length()) {
            if (cs.charAt(inx) > ' ') break;
            ++inx;
        }
        return inx;
    }

    public static int skip(CharSequence cs, char[] chars, int fromIndex) {
        int inx = fromIndex;
        while (inx < cs.length()) {
            char c = cs.charAt(inx);
            boolean hit = false;
            int i = 0;
            while (i < chars.length) {
                if (c == chars[i]) {
                    hit = true;
                    break;
                }
                ++i;
            }
            if (!hit) break;
            ++inx;
        }
        return inx;
    }

    public static int count(Collection c, Object o) {
        if (c instanceof Set) {
            return c.contains(o) ? 1 : 0;
        }
        int count = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (!Eval.isEquals(i.next(), o)) continue;
            ++count;
        }
        return count;
    }

    public static int indexOf(CharSequence cs, char c) {
        return Seek.indexOf(cs, c, 0, cs.length() - 1);
    }

    public static int indexOf(CharSequence cs, char c, int fromIndex) {
        return Seek.indexOf(cs, c, fromIndex, cs.length() - 1);
    }

    public static int indexOf(CharSequence cs, char c, int fromIndex, int toIndex) {
        if (!Eval.isIndex(cs, fromIndex, toIndex)) {
            throw new IllegalArgumentException("no index. length:" + cs.length() + ", fromIndex:" + fromIndex + ", toIndex:" + toIndex);
        }
        int i = fromIndex;
        while (i <= toIndex) {
            if (cs.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence cs, char c) {
        return Seek.lastIndexOf(cs, c, 0, cs.length() - 1);
    }

    public static int lastIndexOf(CharSequence cs, char c, int fromIndex) {
        return Seek.lastIndexOf(cs, c, fromIndex, cs.length() - 1);
    }

    public static int lastIndexOf(CharSequence cs, char c, int fromIndex, int toIndex) {
        if (!Eval.isIndex(cs, fromIndex, toIndex)) {
            throw new IllegalArgumentException("no index. length:" + cs.length() + ", fromIndex:" + fromIndex + ", toIndex:" + toIndex);
        }
        int i = toIndex;
        while (i >= fromIndex) {
            if (cs.charAt(i) == c) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int orIndexOf(CharSequence cs, char[] c) {
        return Seek.orIndexOf(cs, c, 0, cs.length() - 1);
    }

    public static int orIndexOf(CharSequence cs, char[] c, int fromIndex) {
        return Seek.orIndexOf(cs, c, fromIndex, cs.length() - 1);
    }

    public static int orIndexOf(CharSequence cs, char[] c, int fromIndex, int toIndex) {
        if (!Eval.isIndex(cs, fromIndex, toIndex)) {
            throw new IllegalArgumentException("no index. length:" + cs.length() + ", fromIndex:" + fromIndex + ", toIndex:" + toIndex);
        }
        int i = fromIndex;
        while (i <= toIndex) {
            int j = 0;
            while (j < c.length) {
                if (cs.charAt(i) == c[j]) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public static int orLastIndexOf(CharSequence cs, char[] c) {
        return Seek.orLastIndexOf(cs, c, 0, cs.length() - 1);
    }

    public static int orLastIndexOf(CharSequence cs, char[] c, int fromIndex) {
        return Seek.orLastIndexOf(cs, c, fromIndex, cs.length() - 1);
    }

    public static int orLastIndexOf(CharSequence cs, char[] c, int fromIndex, int toIndex) {
        if (!Eval.isIndex(cs, fromIndex, toIndex)) {
            throw new IllegalArgumentException("no index. length:" + cs.length() + ", fromIndex:" + fromIndex + ", toIndex:" + toIndex);
        }
        int i = toIndex;
        while (i >= fromIndex) {
            int j = 0;
            while (j < c.length) {
                if (cs.charAt(i) == c[j]) {
                    return i;
                }
                ++j;
            }
            --i;
        }
        return -1;
    }

    public static int indexOf(CharSequence cs, CharSequence target) {
        return Seek.indexOf(cs, 0, cs.length() - 1, target);
    }

    public static int indexOf(CharSequence cs, int fromIndex, CharSequence target) {
        return Seek.indexOf(cs, fromIndex, cs.length() - 1, target);
    }

    public static int indexOf(CharSequence cs, int fromIndex, int toIndex, CharSequence target) {
        if (!Eval.isIndex(cs, fromIndex, toIndex)) {
            throw new IllegalArgumentException("no index. length:" + cs.length() + ", fromIndex:" + fromIndex + ", toIndex:" + toIndex);
        }
        if (!Eval.isBlank(target)) {
            return -1;
        }
        char first = target.charAt(0);
        int i = fromIndex;
        while (i <= toIndex) {
            if (cs.charAt(i) != first) {
                while (++i <= toIndex && cs.charAt(i) != first) {
                }
            }
            int targetCount = target.length();
            if (i <= toIndex) {
                int j = i + 1;
                int max = j + targetCount - 1;
                int k = 1;
                while (j < max && cs.charAt(j) == target.charAt(k)) {
                    ++j;
                    ++k;
                }
                if (j == max) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(List list, Object o, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(list, fromIndex, toIndex);
        if (o == null) {
            int i = fromIndex;
            while (i <= toIndex) {
                if (list.get(i) == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = fromIndex;
            while (i <= toIndex) {
                if (o.equals(list.get(i))) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(List list, Object o, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(list, fromIndex, toIndex);
        if (o == null) {
            int i = toIndex;
            while (i >= fromIndex) {
                if (list.get(i) == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = toIndex;
            while (i >= fromIndex) {
                if (o.equals(list.get(i))) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public static int indexOf(Object[] a, Object o, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        if (o == null) {
            int i = fromIndex;
            while (i <= toIndex) {
                if (a[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = fromIndex;
            while (i <= toIndex) {
                if (o.equals(a[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Object[] a, Object o, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        if (o == null) {
            int i = toIndex;
            while (i >= fromIndex) {
                if (a[i] == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = toIndex;
            while (i >= fromIndex) {
                if (o.equals(a[i])) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public static int indexOf(boolean[] a, boolean e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = fromIndex;
        while (i <= toIndex) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] a, boolean e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = toIndex;
        while (i >= fromIndex) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int indexOf(char[] a, char e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = fromIndex;
        while (i <= toIndex) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] a, char e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = toIndex;
        while (i >= fromIndex) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int indexOf(byte[] a, byte e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = fromIndex;
        while (i <= toIndex) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] a, byte e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = toIndex;
        while (i >= fromIndex) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int indexOf(short[] a, short e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = fromIndex;
        while (i <= toIndex) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] a, short e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = toIndex;
        while (i >= fromIndex) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int indexOf(int[] a, int e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = fromIndex;
        while (i <= toIndex) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] a, int e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = toIndex;
        while (i >= fromIndex) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int indexOf(long[] a, long e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = fromIndex;
        while (i <= toIndex) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] a, long e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = toIndex;
        while (i >= fromIndex) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int indexOf(float[] a, float e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = fromIndex;
        while (i <= toIndex) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] a, float e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = toIndex;
        while (i >= fromIndex) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int indexOf(double[] a, double e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = fromIndex;
        while (i <= toIndex) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] a, double e, int fromIndex, int toIndex) {
        Seek.checkIndexOfException(a, fromIndex, toIndex);
        int i = toIndex;
        while (i >= fromIndex) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private static void checkIndexOfException(List list, int fromIndex, int toIndex) {
        if (list == null) {
            throw new NullPointerException("list is null.");
        }
        if (!Eval.isIndex(list, fromIndex, toIndex)) {
            throw new IndexOutOfBoundsException("fromIndex:" + fromIndex + ", toIndex:" + toIndex + ", size:" + list.size());
        }
    }

    private static void checkIndexOfException(Object a, int fromIndex, int toIndex) {
        if (a == null) {
            throw new NullPointerException("a is null.");
        }
        if (!Eval.isArray(a)) {
            throw new IllegalArgumentException("is not Array:" + a);
        }
        if (!Eval.isArrayIndex(a, fromIndex, toIndex)) {
            throw new IndexOutOfBoundsException("fromIndex:" + fromIndex + ", toIndex:" + toIndex + ", size:" + Array.getLength(a));
        }
    }
}

