/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections.group;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import shohaku.core.collections.Group;
import shohaku.core.collections.ListUtils;
import shohaku.core.collections.group.AbstractMapGroup;

public class HashListGroup
extends AbstractMapGroup
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4114868662758877981L;
    protected static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int DEFAULT_COLL_INITIAL_CAPACITY = 8;
    protected int initialCapacity;
    protected float loadFactor;
    protected int collInitialCapacity;

    public HashListGroup() {
        this(16, 0.75f);
    }

    public HashListGroup(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashListGroup(Group group) {
        this(Math.max((int)((float)group.size() / 0.75f) + 1, 16), 0.75f);
        this.addAll(group);
    }

    public HashListGroup(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 8);
    }

    public HashListGroup(int initialCapacity, float loadFactor, int listInitialCapacity) {
        this(new HashMap(initialCapacity, loadFactor));
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.collInitialCapacity = listInitialCapacity;
    }

    protected HashListGroup(Map groupMap) {
        super(groupMap);
    }

    protected Collection newEntryCollection() {
        return ListUtils.wrappedList(new ArrayList(this.collInitialCapacity));
    }

    public Object clone() {
        HashListGroup result = new HashListGroup(this.initialCapacity, this.loadFactor, this.collInitialCapacity);
        result.addAll(this);
        return result;
    }
}

