/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import shohaku.core.lang.Boxing;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.SAXContentHandler;

public class SAXDocumentParser {
    private SAXParserFactory saxParserFactory;
    private SAXParser saxParser;
    private XMLReader xmlReader;
    private EntityResolver entityResolver;
    private DTDHandler dtdHandler;
    private ErrorHandler errorHandler;
    private Map features = new HashMap();
    private Map properties = new HashMap();
    private Boolean isNamespaceAware;
    private Boolean isValidating;
    private final Ginkgo ginkgo;

    SAXDocumentParser(Ginkgo ginkgo) {
        this.ginkgo = ginkgo;
    }

    void parse(InputSource input) throws IOException, SAXException {
        this.prepare();
        XMLReader xmlReader = this.getXMLReader();
        xmlReader.parse(input);
    }

    private void prepare() throws SAXException {
        try {
            ErrorHandler _errorHandler;
            DTDHandler _dtdHandler;
            Boolean _isNamespaceAware;
            SAXParserFactory _saxParserFactory = this.getSAXParserFactory();
            Boolean _isValidating = this.getValidating();
            if (_isValidating != null) {
                _saxParserFactory.setValidating(_isValidating);
            }
            if ((_isNamespaceAware = this.getNamespaceAware()) != null) {
                _saxParserFactory.setNamespaceAware(_isNamespaceAware);
            }
            Iterator i = this.features.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                String name = (String)e.getKey();
                boolean value = (Boolean)e.getValue();
                _saxParserFactory.setFeature(name, value);
            }
            SAXParser _saxParser = this.getSAXParser();
            Iterator i2 = this.properties.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry e = i2.next();
                String name = (String)e.getKey();
                Object value = e.getValue();
                _saxParser.setProperty(name, value);
            }
            XMLReader _xmlReader = this.getXMLReader();
            _xmlReader.setContentHandler(this.newContentHandler());
            EntityResolver _entityResolver = this.getEntityResolver();
            if (_entityResolver != null) {
                _xmlReader.setEntityResolver(_entityResolver);
            }
            if ((_dtdHandler = this.getDTDHandler()) != null) {
                _xmlReader.setDTDHandler(_dtdHandler);
            }
            if ((_errorHandler = this.getErrorHandler()) != null) {
                _xmlReader.setErrorHandler(_errorHandler);
            } else {
                _xmlReader.setErrorHandler(this.newDefaultErrorHandler());
            }
        }
        catch (ParserConfigurationException e) {
            this.ginkgo.getLogger().error((Object)"SAXDocumentParser.setFeature:", (Throwable)e);
            throw new SAXException(e);
        }
    }

    private SAXParserFactory getSAXParserFactory() throws SAXException {
        try {
            if (this.saxParserFactory == null) {
                this.saxParserFactory = SAXParserFactory.newInstance();
            }
            return this.saxParserFactory;
        }
        catch (FactoryConfigurationError e) {
            this.ginkgo.getLogger().error((Object)"SAXDocumentParser.getSAXParserFactory:", (Throwable)e);
            throw new SAXException(e.getException());
        }
    }

    private SAXParser getSAXParser() throws SAXException {
        try {
            if (this.saxParser == null) {
                this.saxParser = this.getSAXParserFactory().newSAXParser();
            }
            return this.saxParser;
        }
        catch (ParserConfigurationException e) {
            this.ginkgo.getLogger().error((Object)"SAXDocumentParser.newSAXParser:", (Throwable)e);
            throw new SAXException(e);
        }
    }

    private XMLReader getXMLReader() throws SAXException {
        if (this.xmlReader == null) {
            this.xmlReader = this.getSAXParser().getXMLReader();
        }
        return this.xmlReader;
    }

    public boolean getFeature(String name) {
        Boolean feature = (Boolean)this.features.get(name);
        return feature != null ? feature : false;
    }

    public void setFeature(String name, boolean value) {
        this.features.put(name, Boxing.box((boolean)value));
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    private ContentHandler newContentHandler() {
        return new SAXContentHandler(this.ginkgo);
    }

    private ErrorHandler newDefaultErrorHandler() {
        return new DefaultErrorHandler(this.ginkgo);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public Boolean getNamespaceAware() {
        return this.isNamespaceAware;
    }

    public void setNamespaceAware(Boolean isNamespaceAware) {
        this.isNamespaceAware = isNamespaceAware;
    }

    public Boolean getValidating() {
        return this.isValidating;
    }

    public void setValidating(Boolean isValidating) {
        this.isValidating = isValidating;
    }

    private static class DefaultErrorHandler
    implements ErrorHandler {
        private final Ginkgo ginkgo;

        DefaultErrorHandler(Ginkgo ginkgo) {
            this.ginkgo = ginkgo;
        }

        public void warning(SAXParseException e) throws SAXException {
            this.ginkgo.getLogger().warn((Object)"ErrorHandler.warning:", (Throwable)e);
        }

        public void error(SAXParseException e) throws SAXException {
            this.ginkgo.getLogger().error((Object)"ErrorHandler.error:", (Throwable)e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.ginkgo.getLogger().fatal((Object)"ErrorHandler.fatalError:", (Throwable)e);
            throw e;
        }
    }
}

