/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo;

import java.util.HashMap;
import java.util.Iterator;
import shohaku.core.helpers.Eval;
import shohaku.ginkgo.DocumentContext;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.NodeCompositeRule;

public class Document {
    private final DocumentContext context;
    private final Document parent;
    private String id;
    private final HashMap nodeValueMap;
    private final boolean isPreserve;

    Document(Ginkgo ginkgo, NodeCompositeRule rule, Document parent) {
        this.context = new DocumentContext(ginkgo, rule);
        this.parent = parent;
        this.nodeValueMap = new HashMap();
        this.isPreserve = false;
    }

    private Document(Document srcDocument) {
        this.context = null;
        this.parent = srcDocument.parent;
        this.id = srcDocument.id;
        this.nodeValueMap = srcDocument.nodeValueMap;
        this.isPreserve = true;
    }

    public DocumentContext getContext() {
        return this.context;
    }

    public Document getParent() {
        return this.parent;
    }

    public String getId() {
        return this.id;
    }

    void setId(String documentId) {
        this.id = documentId;
    }

    public Iterator getNodeValueIdIterator() {
        return this.nodeValueMap.keySet().iterator();
    }

    public boolean containsId(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (Eval.isContains((String)id, (char)':')) {
            int off = id.indexOf(58);
            String documentId = id.substring(0, off);
            String nodeId = id.substring(++off);
            return this.containsId(documentId, nodeId);
        }
        return this.nodeValueMap.containsKey(id);
    }

    private boolean containsId(String documentId, String nodeId) {
        if (documentId.equals(this.getId())) {
            return this.nodeValueMap.containsKey(nodeId);
        }
        if (this.getParent() != null) {
            return this.getParent().containsId(documentId, nodeId);
        }
        return false;
    }

    public Object getNodeValueById(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (Eval.isContains((String)id, (char)':')) {
            int off = id.indexOf(58);
            String documentId = id.substring(0, off);
            String nodeId = id.substring(++off);
            return this.getNodeValueById(documentId, nodeId);
        }
        return this.nodeValueMap.get(id);
    }

    private Object getNodeValueById(String documentId, String nodeId) {
        if (documentId.equals(this.getId())) {
            return this.nodeValueMap.get(nodeId);
        }
        if (this.getParent() != null) {
            return this.getParent().getNodeValueById(documentId, nodeId);
        }
        return null;
    }

    void addReferenceNodeValue(Node node) {
        String id;
        if (node == null) {
            throw new NullPointerException();
        }
        if (node.isType(3) && !Eval.isBlank((CharSequence)(id = node.getId()))) {
            if (this.nodeValueMap.containsKey(id)) {
                throw new GinkgoException("That ID has already been registered. id:" + id + ".");
            }
            this.nodeValueMap.put(id, node.getNodeValue());
        }
    }

    public boolean isPreserve() {
        return this.isPreserve;
    }

    public Document getPreserveDocument() {
        return new Document(this);
    }

    void startElement(Node node) {
    }

    void endElement(Node node) {
        this.addReferenceNodeValue(node);
    }
}

