/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.sample.kosho;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;

import shohaku.core.lang.ResourceLoader;
import shohaku.core.util.debug.Debug;
import shohaku.ginkgo.Document;
import shohaku.kosho.XMLProperties;

/**
 * shohaku.kosho.XMLProperties の実装サンプルです。<br>
 * 定義ファイルは同フォルダ下の root-xml-properties.xml と child-xml-properties.xml です。<br>
 * サンプルではデフォルトで用意されるノード実装から任意に例を配備しています。これ以外にも多彩な定義が可能です。<br>
 * <br>
 * また構成ルールを独自に定義すれば使用する機能の縮小や拡張を自在に変更する事が出来ます。<br>
 * また必要に応じて（使用可能なタグの種別等の）制約を追加する事が可能です。<br>
 * デフォルト構成ルールは conf フォルダ下の"shohaku/kosho/xml-properties-default-rule.xml" に配置されています。
 */
public class SampleXMLProperties {

    /**
     * サンプルを実行します、処理のコンソール出力を行います。
     * 
     * @param args
     */
    public static void main(String[] args) {

        try {
            XMLProperties xmlProperties = new XMLProperties();

            InputStream rootInStream = ResourceLoader
                    .getResourceAsStream("shohaku/sample/kosho/root-xml-properties.xml");
            InputStream jpIninStream = ResourceLoader
                    .getResourceAsStream("shohaku/sample/kosho/child-xml-properties.xml");

            // ルートプロパティの読み取り
            xmlProperties.load(rootInStream);

            // ルートプロパティのドキュメント取得
            Document root = xmlProperties.getDocument();

            // ルートプロパティを親として子プロパティを読み取る
            xmlProperties.load(jpIninStream, root);

            // マップ表現を取得
            Map properties = xmlProperties.toMap();

            // コンソール出力

            Debug.out.printLineln(60);
            Debug.out.println("サンプルを実行します。スラッシュ区切りの階層構造のプロパティです。");
            Debug.out.printLineln(60);
            Debug.out.printlf(1);
            for (Iterator i = properties.entrySet().iterator(); i.hasNext();) {
                Map.Entry e = (Map.Entry) i.next();
                Debug.out.print(e.getKey());
                Debug.out.print('=');
                Debug.out.print(e.getValue());
                Debug.out.println();
            }
            Debug.out.printlf(1);
            Debug.out.printLineln(60);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
