/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.sample.kosho;

import java.util.List;

import shohaku.core.util.debug.Debug;
import shohaku.kosho.ComponentFactory;

/**
 * shohaku.kosho.ComponentFactory の実装サンプルです。<br>
 * 定義ファイルは同フォルダ下の sample-component-factory.xmlです。<br>
 * このコンポーネントを使えば容易にコンポーネント生成の仕組みを組み込むことが出来ます。<br>
 * 柔軟さ軽量さを求めて設計してあります。<br>
 * <br>
 * また構成ルールを独自に定義すれば使用する機能の縮小や拡張を自在に変更する事が出来ます。<br>
 * また必要に応じて（使用可能なタグの種別等の）制約を追加する事が可能です。<br>
 * デフォルト構成ルールは conf フォルダ下の"shohaku/kosho/component-factory-default-rule.xml" に配置されています。
 */
public class SampleComponentFactory {

    /**
     * サンプルを実行します、処理のコンソール出力を行います。
     * 
     * @param args
     */
    public static void main(String[] args) {

        try {

            ComponentFactory factory = ComponentFactory.getFactory("shohaku/sample/kosho/sample-component-factory.xml");
            {
                // ////////////////////////////////////////////////////
                Debug.out.printLineln(60);
                Debug.out.println("コンポーネント生成のサンプル");
                Debug.out.printLineln(60);
                Debug.out.printlf(1);

                Debug.out.println("componentId=new:constructor");
                Debug.out.printBean(factory.getComponent("new:constructor"));
                Debug.out.printlf(2);

                Debug.out.println("componentId=new:factory");
                Debug.out.printBean(factory.getComponent("new:factory"));
                Debug.out.printlf(2);

                Debug.out.println("componentId=new:property");
                Debug.out.printBean(factory.getComponent("new:property"));
                Debug.out.printlf(2);

                Debug.out.println("componentId=new:method");
                Debug.out.printBean(factory.getComponent("new:method"));
                Debug.out.printlf(1);

                // ////////////////////////////////////////////////////
                Debug.out.printlf(1);
                Debug.out.printLineln(60);
                Debug.out.println("生成タイプのサンプル");
                Debug.out.printLineln(60);
                Debug.out.printlf(1);

                Debug.out.println("<プロトタイプで定義、毎回新規生成する, componentId=type:prototype>");
                Debug.out.println("1. 取得する");
                Lake prototype = (Lake) factory.getComponent("type:prototype");
                Debug.out.printBean(prototype);
                Debug.out.printlf(1);
                Debug.out.println("2. 名前を”洞爺湖”に変更する");
                prototype.setName("洞爺湖");
                Debug.out.printBean(prototype);
                Debug.out.printlf(1);
                Debug.out.println("3. 再取得する、新規に生成される");
                Debug.out.printBean(factory.getComponent("type:prototype"));
                Debug.out.printlf(2);

                Debug.out.println("<シングルトンで定義、一度のみ生成する, componentId=type:singleton>");
                Debug.out.println("1. 取得する");
                Lake singleton = (Lake) factory.getComponent("type:singleton");
                Debug.out.printBean(singleton);
                Debug.out.printlf(1);
                Debug.out.println("2. 名前を”洞爺湖”に変更する");
                singleton.setName("洞爺湖");
                Debug.out.printBean(singleton);
                Debug.out.printlf(1);
                Debug.out.println("3. 再取得する、変更されたインスタンスが再度返される");
                Debug.out.printBean(factory.getComponent("type:singleton"));
                Debug.out.printlf(1);

                // ////////////////////////////////////////////////////
                Debug.out.printlf(1);
                Debug.out.printLineln(60);
                Debug.out.println("コンポーネント参照のサンプル");
                Debug.out.printLineln(60);
                Debug.out.printlf(1);

                Debug.out.println("リスト内に格納する、componentId=ref:list");
                Debug.out.printCollTbl((List) factory.getComponent("ref:list"));
                Debug.out.printlf(1);

                Debug.out.println("CEL式で格納する（上記と同じ結果）、componentId=ref:cel-list");
                Debug.out.printCollTbl((List) factory.getComponent("ref:cel-list"));
                Debug.out.printlf(1);

                // ////////////////////////////////////////////////////
                Debug.out.printLineln(60);

            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
