/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.kosho;

import java.util.Iterator;

/**
 * コンフィギュレーションリソースを格納する機能を提供します。
 */
public interface KoshoResources {

    /**
     * 全てのキーを含む反復子を返却します。
     * 
     * @return 全てのキーを含む反復子
     */
    Iterator keyIterator();

    /**
     * 指定されたキーが示す値を返却します。 <br>
     * 指定されたキーが存在しない場合<code>null</code>返却します。
     * 
     * @param key
     *            キー
     * @return キーが示す値
     * @throws NullPointerException
     *             key が null の場合発生する
     */
    Object getObject(String key);

    /**
     * 指定されたキーが示す値を返却します。 <br>
     * 指定されたキーが存在しない場合<code>defaultValue</code>を返却します。
     * 
     * @param key
     *            キー
     * @param defaultValue
     *            デフォルト値
     * @return キーが示す値
     * @throws NullPointerException
     *             key が null の場合発生する
     */
    Object getObject(String key, Object defaultValue);

    /**
     * 指定されたキーがデータに含まれている場合に<code>true</code>を返却します。
     * 
     * @param key
     *            キー
     * @return 指定されたキーが含まれている場合 true
     * @throws UnsupportedOperationException
     *             実装が containsKey オペレーションをサポートしない場合
     */
    boolean containsKey(String key);

    /**
     * 指定されたキーがデータに含まれていると同時に、指定されたクラスとキャスト可能な場合に<code>true</code>を返す。 <br>
     * 値がNullの場合キャスト可能(True)を返却します。
     * 
     * @param key
     *            キー
     * @param type
     *            キャスト可能な関係に有るか検証するクラス
     * @return 指定されたキーが含まれている場合 true
     * @throws NullPointerException
     *             key または type が null の場合発生する
     */
    boolean containsKey(String key, Class type);
}