/*
 * Decompiled with CFR 0.152.
 */
package shohaku.kosho;

import java.io.BufferedInputStream;
import java.io.InputStream;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.ResourceLoader;
import shohaku.core.util.XResourceBundleBaseCalculator;
import shohaku.ginkgo.Document;
import shohaku.ginkgo.DocumentCompositeRule;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.NodeCompositeRule;
import shohaku.ginkgo.helpers.NodeCompositeRuleLoader;

public class KoshoHelper {
    public static InputStream getGinkgoBundleInputStream(ClassLoader loader, String bundleName) {
        String resName = String.valueOf(bundleName.replace('.', '/')) + ".xml";
        InputStream stream = null;
        try {
            stream = ResourceLoader.getResourceAsStream((String)resName, (ClassLoader)loader);
        }
        catch (NoSuchResourceException noSuchResourceException) {
            // empty catch block
        }
        if (stream != null) {
            return new BufferedInputStream(stream);
        }
        return null;
    }

    public static NodeCompositeRule findGinkgoBundleNodeCompositeRule(Class resourceBundle, ClassLoader loader, String baseName) {
        String ruleName = String.valueOf(baseName.replace('.', '/')) + "_rule.xml";
        NodeCompositeRule rule = null;
        try {
            rule = NodeCompositeRuleLoader.getNodeCompositeRule((String)ruleName, (ClassLoader)loader);
        }
        catch (NoSuchResourceException noSuchResourceException) {
            // empty catch block
        }
        if (rule == null) {
            rule = KoshoHelper.loadDefaultNodeCompositeRule(resourceBundle, resourceBundle.getClassLoader());
        }
        return rule;
    }

    public static DocumentCompositeRule getGinkgoBundleDocumentCompositeRule(XResourceBundleBaseCalculator calculator, Object bundleBase) {
        final String id = calculator.candidateBundleId(bundleBase);
        DocumentCompositeRule rule = new DocumentCompositeRule(){

            public String getDocumentId(Document document, Node root) {
                return id;
            }
        };
        return rule;
    }

    public static NodeCompositeRule loadDefaultNodeCompositeRule(Class c, ClassLoader classLoader) {
        String ruleFileName = KoshoHelper.getRuleFileBaseName(c);
        String packagePath = c.getPackage().getName().replace('.', '/');
        String defaultRuleFile = String.valueOf(packagePath) + "/" + ruleFileName + "-default-rule.xml";
        String customRuleFile = String.valueOf(ruleFileName) + "-rule.xml";
        NodeCompositeRule rule = null;
        try {
            rule = NodeCompositeRuleLoader.getNodeCompositeRule((String)customRuleFile, (ClassLoader)classLoader);
        }
        catch (NoSuchResourceException noSuchResourceException) {
            // empty catch block
        }
        if (rule == null) {
            try {
                rule = NodeCompositeRuleLoader.getNodeCompositeRule((String)defaultRuleFile, (ClassLoader)classLoader);
            }
            catch (NoSuchResourceException e) {
                throw new GinkgoException("It failed in reading of the file of the composition rule.", (Throwable)e);
            }
        }
        return rule;
    }

    private static String getRuleFileBaseName(Class c) {
        StringBuffer buf = new StringBuffer();
        String className = c.getName();
        int off = className.lastIndexOf(46);
        if (off >= 0) {
            ++off;
        }
        char[] chars = className.substring(off).toCharArray();
        int i = 0;
        while (i < chars.length) {
            char ch = chars[i];
            if (i > 0 && 'A' <= ch && ch <= 'Z') {
                if (i + 1 < chars.length) {
                    char next = chars[i + 1];
                    if ('a' <= next && next <= 'z') {
                        buf.append('-');
                    }
                } else {
                    buf.append('-');
                }
            }
            buf.append(Character.toLowerCase(ch));
            ++i;
        }
        return buf.toString();
    }
}

