/*
 * Decompiled with CFR 0.152.
 */
package shohaku.kosho;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import shohaku.core.beans.BeansFactory;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.ResourceLoader;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.NodeCompositeRule;
import shohaku.kosho.Kosho;

public class ComponentFactory {
    private final Map lookup = new LinkedHashMap();
    private final Ginkgo ginkgo = new Ginkgo();
    static /* synthetic */ Class class$0;

    private ComponentFactory(InputStream inStream, ClassLoader classLoader) {
        this.load(inStream, this.getDefaultNodeCompositeRule(), classLoader);
    }

    private void load(InputStream inStream, NodeCompositeRule rule, ClassLoader classLoader) throws GinkgoException {
        this.ginkgo.setClassLoader(classLoader);
        this.ginkgo.parse(rule, inStream);
        Node root = this.ginkgo.getDocument().getContext().getRoot();
        LinkedHashMap lookupValues = new LinkedHashMap();
        this.initValues(root, lookupValues);
        this.lookup.putAll(lookupValues);
    }

    private void initValues(Node root, Map values) throws GinkgoException {
        Iterator iter = root.getContext().elementIterator("components");
        while (iter.hasNext()) {
            Node components = (Node)iter.next();
            String name = components.getAttribute("name");
            if (name == null || name.length() == 0) {
                throw new GinkgoException("components name is null.");
            }
            this.initComponentValues(components, name, values);
        }
    }

    private void initComponentValues(Node components, String groupName, Map values) throws GinkgoException {
        Iterator iter = components.getContext().elementIterator("component");
        while (iter.hasNext()) {
            Node component = (Node)iter.next();
            String name = component.getAttribute("name");
            if (name == null || name.length() == 0) {
                throw new GinkgoException("component name is null.");
            }
            values.put(String.valueOf(groupName) + ':' + name, component.getNodeValue());
        }
    }

    public Object getComponent(String componentId) throws ObjectCreationException {
        if (componentId == null) {
            throw new NullPointerException("componentId is null.");
        }
        BeansFactory o = (BeansFactory)this.lookup.get(componentId);
        if (o == null) {
            throw new ObjectCreationException("componentId is illegal. componentId:" + componentId);
        }
        return o.getInstance();
    }

    public NodeCompositeRule getDefaultNodeCompositeRule() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.kosho.ComponentFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return Kosho.getDefaultNodeCompositeRule(clazz);
    }

    public static ComponentFactory getFactory(String resourcePath) throws NoSuchResourceException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.kosho.ComponentFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ComponentFactory.getFactory(resourcePath, clazz.getClassLoader());
    }

    public static ComponentFactory getFactory(String resourcePath, ClassLoader classLoader) throws NoSuchResourceException {
        return ComponentFactory.getFactoryForCache(resourcePath, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ComponentFactory getFactoryForCache(String resourcePath, ClassLoader classLoader) throws NoSuchResourceException {
        if (resourcePath == null) {
            throw new NullPointerException("resourcePath is null.");
        }
        Map map = FactoryCache.cache;
        synchronized (map) {
            ComponentFactory factory = (ComponentFactory)FactoryCache.cache.get(resourcePath);
            if (factory != null) {
                return factory;
            }
            InputStream inStream = ResourceLoader.getResourceAsStream((String)resourcePath, (ClassLoader)classLoader);
            factory = new ComponentFactory(inStream, classLoader);
            FactoryCache.cache.put(resourcePath, factory);
            return factory;
        }
    }

    private static final class FactoryCache {
        static final Map cache = new Hashtable();

        FactoryCache() {
        }
    }
}

