/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util;

import java.util.Hashtable;
import java.util.MissingResourceException;
import shohaku.core.helpers.Eval;
import shohaku.core.util.XResourceBundle;
import shohaku.core.util.XResourceBundleBaseCalculator;
import shohaku.core.util.XResourceBundleCreater;

public class XResourceBundleCache {
    private static final int INITIAL_CACHE_SIZE = 25;
    private static final float CACHE_LOAD_FACTOR = 1.0f;
    private final Hashtable bundleCache = new Hashtable(25, 1.0f);
    private final Hashtable lockObjects = new Hashtable(25, 1.0f);
    private final XResourceBundleCreater bundleCreater;
    private final XResourceBundleBaseCalculator bundleBaseCalculator;

    public XResourceBundleCache(XResourceBundleCreater creater) {
        this.bundleCreater = creater;
        this.bundleBaseCalculator = creater.getBundleBaseCalculator();
    }

    public XResourceBundle getBundle(String baseName, Object bundleBase, ClassLoader loader) {
        return this.getBundleImpl(baseName, bundleBase, loader);
    }

    public ClassLoader getDefaultLoader() {
        return this.bundleCreater.getDefaultClassLoader();
    }

    private XResourceBundle getBundleImpl(String baseName, Object bundleBase, ClassLoader loader) {
        if (Eval.isOrNull(baseName, bundleBase, loader)) {
            throw new NullPointerException();
        }
        XResourceBundle bundle = this.findBundle(loader, bundleBase, baseName);
        if (bundle == null) {
            throw new MissingResourceException("Can't find bundle for base name. " + baseName + ", " + bundleBase, baseName, bundleBase.toString());
        }
        return bundle;
    }

    private XResourceBundle findBundle(ClassLoader loader, Object bundleBase, String baseName) {
        XResourceBundle target = null;
        String[] bundleNames = null;
        Object defaultBundle = this.bundleBaseCalculator.getDefaultBundleBase();
        if (!Eval.isEquals(defaultBundle, bundleBase)) {
            bundleNames = this.bundleBaseCalculator.candidateHierarchyBundleNames(baseName, bundleBase);
            target = this.loadBundle(loader, baseName, bundleNames);
        }
        if (target == null && (target = this.loadBundle(loader, baseName, bundleNames = this.bundleBaseCalculator.candidateHierarchyBundleNames(baseName, defaultBundle))) == null) {
            target = this.createBundle(loader, baseName, baseName, null);
        }
        return target;
    }

    private XResourceBundle loadBundle(ClassLoader loader, String baseName, String[] bundleNames) {
        XResourceBundle parent = null;
        XResourceBundle target = null;
        XResourceBundle bundle = null;
        int i = 0;
        while (i < bundleNames.length) {
            String bundleName = bundleNames[i];
            if (bundleName != null && (bundle = this.createBundle(loader, baseName, bundleName, parent)) != null) {
                parent = bundle;
                if (i != 0) {
                    target = bundle;
                }
            }
            ++i;
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XResourceBundle createBundle(ClassLoader loader, String baseName, String bundleName, XResourceBundle parent) {
        XResourceBundle bundle = null;
        Object object = this.getLockObject(bundleName);
        synchronized (object) {
            Object bundleBase;
            bundle = (XResourceBundle)this.findBundleInCache(bundleName);
            if (bundle == null && (bundle = this.bundleCreater.createBundle(loader, parent, bundleBase = this.bundleBaseCalculator.calculateBundleBase(baseName, bundleName), baseName, bundleName)) != null) {
                this.putBundleInCache(bundleName, bundle);
            }
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getLockObject(String bundleName) {
        Hashtable hashtable = this.lockObjects;
        synchronized (hashtable) {
            Object key = this.lockObjects.get(bundleName);
            if (key == null) {
                key = new Object();
                this.lockObjects.put(bundleName, key);
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findBundleInCache(String bundleName) {
        Hashtable hashtable = this.bundleCache;
        synchronized (hashtable) {
            return this.bundleCache.get(bundleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putBundleInCache(String bundleName, Object value) {
        Hashtable hashtable = this.bundleCache;
        synchronized (hashtable) {
            this.bundleCache.put(bundleName, value);
        }
    }
}

