/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.io;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import shohaku.core.beans.BeanUtilities;
import shohaku.core.helpers.Eval;
import shohaku.core.lang.VariableInteger;

public class IntrospectPrintStream
extends PrintStream {
    public static final int DEFAULT_REPETITION_LIMIT = 1024;
    private int repetitionLimit = 1024;

    public IntrospectPrintStream() {
        this(System.out);
    }

    public IntrospectPrintStream(boolean autoFlush) {
        this(System.out, autoFlush);
    }

    public IntrospectPrintStream(OutputStream out) {
        this(out, false);
    }

    public IntrospectPrintStream(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public void print(Object o) {
        if (o == null) {
            this.printNull();
            return;
        }
        if (o.getClass().isArray()) {
            this.printArray(o);
        } else if (o instanceof Map) {
            this.printMap((Map)o);
        } else if (o instanceof Collection) {
            this.printColl((Collection)o);
        } else {
            super.print(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printlf(int len) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            int i = 0;
            while (i < len) {
                this.println();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printsp(int len) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            int i = 0;
            while (i < len) {
                this.print(' ');
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printArray(Object a) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            if (a == null) {
                this.printNull();
            } else if (a.getClass().isArray()) {
                this.printClass(a);
                this.printDeepArrays(a);
            } else {
                super.print(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printArray(Object title, Object a) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            this.print(title);
            this.print(" : ");
            this.println();
            this.printArray(a);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printColl(Collection c) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            if (c == null) {
                this.printNull();
            } else if (c.size() == 0) {
                this.printClass(c);
                this.print("[]");
            } else {
                this.printClass(c);
                super.print('[');
                Iterator i = c.iterator();
                boolean hasNext = i.hasNext();
                while (hasNext) {
                    Object o = i.next();
                    this.print((Object)(o == c ? "(this Collection)" : o));
                    hasNext = i.hasNext();
                    if (!hasNext) continue;
                    super.print(", ");
                }
                super.print(']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMap(Map m) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            if (m == null) {
                this.printNull();
            } else if (m.size() == 0) {
                this.printClass(m);
                this.print("{}");
            } else {
                this.printClass(m);
                this.print('{');
                boolean st = true;
                Iterator i = m.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    Object key = e.getKey();
                    Object value = e.getValue();
                    if (st) {
                        st = false;
                    } else {
                        this.print(", ");
                    }
                    this.print((Object)(key == m ? "(this Map)" : key));
                    this.print(':');
                    this.print((Object)(value == m ? "(this Map)" : value));
                }
                this.print('}');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBean(Object bean) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            Map props;
            try {
                props = BeanUtilities.getProperties(bean);
            }
            catch (Exception e) {
                this.println();
                return;
            }
            this.printClass(bean);
            this.print('{');
            boolean st = true;
            Iterator i = props.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if ("class".equals(e.getKey())) continue;
                if (st) {
                    st = false;
                } else {
                    this.print(", ");
                }
                this.print((String)e.getKey());
                this.print('=');
                this.print(e.getValue());
            }
            this.print('}');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBeans(Object[] beans) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            this.printClass(beans);
            this.println();
            this.println('[');
            int i = 0;
            while (i < beans.length) {
                this.printsp(2);
                this.print('[');
                this.print(i);
                this.print(']');
                this.printBean(beans[i]);
                this.println();
                ++i;
            }
            this.println(']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printConstants(Class c) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            try {
                this.printClass(c);
                Field[] fields = c.getFields();
                this.println('{');
                int i = 0;
                while (i < fields.length) {
                    int modifiers = fields[i].getModifiers();
                    if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                        this.printsp(2);
                        this.print("public static final ");
                        if (Modifier.isTransient(modifiers)) {
                            this.print("transient ");
                        }
                        this.print(fields[i].getName());
                        this.print(" = ");
                        this.println(fields[i].get(null));
                    }
                    ++i;
                }
                this.println('}');
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printFields(Object o) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            try {
                this.printClass(o);
                Field[] fields = o.getClass().getFields();
                this.println('{');
                int i = 0;
                while (i < fields.length) {
                    int modifiers = fields[i].getModifiers();
                    if (Modifier.isPublic(modifiers)) {
                        this.printsp(2);
                        this.print("public ");
                        if (Modifier.isStatic(modifiers)) {
                            this.print("static ");
                        }
                        if (Modifier.isFinal(modifiers)) {
                            this.print("final ");
                        }
                        if (Modifier.isTransient(modifiers)) {
                            this.print("transient ");
                        }
                        if (Modifier.isVolatile(modifiers)) {
                            this.print("volatile ");
                        }
                        this.print(fields[i].getName());
                        this.print(" = ");
                        this.println(fields[i].get(o));
                    }
                    ++i;
                }
                this.println('}');
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printClass(Object o) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            if (o == null) {
                return;
            }
            super.print('<');
            super.print(o instanceof Class ? ((Class)o).getName() : o.getClass().getName());
            super.print('>');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printClass(Object[] o) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            if (o == null) {
                return;
            }
            super.print('<');
            this.print(o.getClass().getComponentType().getName());
            this.print('[');
            this.print(o.length);
            this.print(']');
            super.print('>');
        }
    }

    public void printNull() {
        this.print("null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printDeepArrays(Object a) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            if (a == null) {
                this.printNull();
                return;
            }
            Class<?> aClass = a.getClass();
            if (aClass.isArray()) {
                this.printDeepArrays(a, new VariableInteger(), 0);
            } else {
                this.print(a);
            }
        }
    }

    private void printDeepArrays(Object a, VariableInteger count, int row) {
        if (a == null) {
            this.printNull();
            return;
        }
        super.print('[');
        int i = 0;
        while (i < Array.getLength(a)) {
            Object e;
            if (count.intValue() >= this.getRepetitionLimit()) {
                super.print("...");
                return;
            }
            count.increment();
            if (i != 0) {
                this.print(", ");
            }
            if ((e = Array.get(a, i)) == null) {
                this.printNull();
            } else {
                Class<?> eClass = e.getClass();
                if (eClass.isArray()) {
                    this.printDeepArrays(e, count, row + 1);
                } else {
                    this.print(e);
                }
            }
            ++i;
        }
        super.print(']');
    }

    public int getRepetitionLimit() {
        return this.repetitionLimit;
    }

    public void setRepetitionLimit(int repetitionLimit) {
        if (Eval.isNegative(repetitionLimit)) {
            throw new IllegalArgumentException("0 > " + repetitionLimit);
        }
        this.repetitionLimit = repetitionLimit;
    }
}

