/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections.params;

import java.util.Iterator;
import java.util.NoSuchElementException;
import shohaku.core.collections.KayValueIterator;
import shohaku.core.collections.KayValueIteratorUtils;

abstract class BaseParameters
implements Cloneable {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    BaseEntry[] table;
    BaseEntry endEntry;
    int size;
    int hashCode;

    BaseParameters() {
        this(KayValueIteratorUtils.emptyKayValueIterator());
    }

    BaseParameters(KayValueIterator i) {
        this.size = i.size();
        this.table = new BaseEntry[this.capacity(this.size)];
        this.putAllForCreate(i);
    }

    void putAllForCreate(KayValueIterator i) {
        BaseEntry _entry = null;
        BaseEntry _beginEntry = null;
        while (i.hasNext()) {
            i.next();
            String name = i.getKey().toString();
            Object value = i.getValue();
            int hashCode = this.hash(name);
            int index = this.indexFor(hashCode, this.table.length);
            BaseEntry newEntry = this.newEntry(name, value, hashCode);
            BaseEntry oldEntry = this.putEntry(index, newEntry);
            if (oldEntry != null) {
                if (oldEntry == _entry) {
                    _entry = oldEntry.before;
                }
                if (oldEntry == _beginEntry) {
                    _beginEntry = oldEntry.after;
                }
            }
            if (_entry != null) {
                _entry.after = newEntry;
                newEntry.before = _entry;
            } else {
                _beginEntry = newEntry;
            }
            _entry = newEntry;
        }
        if (_entry != null) {
            this.endEntry = _entry;
            this.endEntry.after = _beginEntry;
            _beginEntry.before = this.endEntry;
        } else {
            this.endEntry = null;
        }
        this.hashCode = BaseParameters._hashCode(this);
    }

    abstract BaseEntry newEntry(String var1, Object var2, int var3);

    public int size() {
        return this.size;
    }

    public Iterator iterator() {
        return new ParametersIterator();
    }

    public KayValueIterator kayValueIterator() {
        return new ParametersKayValueIterator();
    }

    public boolean isEmpty() {
        return this.endEntry == null;
    }

    public String getName(int index) {
        BaseEntry e = this.getEntry(index);
        if (e != null) {
            return e.name;
        }
        return null;
    }

    public int getIndex(String name) {
        return this.getEntryIndex(name);
    }

    public Object getValue(String name) {
        BaseEntry e = this.getEntry(name);
        if (e != null) {
            return e.value;
        }
        return null;
    }

    public Object getValue(String name, String defaultValue) {
        BaseEntry e = this.getEntry(name);
        if (e != null) {
            return e.value;
        }
        return defaultValue;
    }

    public Object getValue(int index) {
        BaseEntry e = this.getEntry(index);
        if (e != null) {
            return e.value;
        }
        return null;
    }

    public Object getValue(int index, String defaultValue) {
        BaseEntry e = this.getEntry(index);
        if (e != null) {
            return e.value;
        }
        return defaultValue;
    }

    public boolean containsName(String name) {
        return this.getEntry(name) != null;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public abstract Object clone();

    int getEntryIndex(String name) {
        if (name == null) {
            throw new NullPointerException("entry name is null");
        }
        if (!this.isEmpty()) {
            BaseEntry e = this.endEntry.after;
            int i = 0;
            while (i < this.size) {
                if (name.equals(e.name)) {
                    return i;
                }
                e = e.after;
                ++i;
            }
        }
        return -1;
    }

    BaseEntry getEntry(String name) {
        if (name == null) {
            throw new NullPointerException("entry name is null");
        }
        if (!this.isEmpty()) {
            int hashCode = this.hash(name);
            int index = this.indexFor(hashCode, this.table.length);
            BaseEntry e = this.table[index];
            while (e != null) {
                if (e.hashCode == hashCode && name.equals(e.name)) {
                    return e;
                }
                e = e.next;
            }
        }
        return null;
    }

    BaseEntry getEntry(int index) {
        if (this.isEmpty() || index < 0 || index >= this.size) {
            return null;
        }
        if (index < this.size >> 1) {
            BaseEntry e = this.endEntry.after;
            int i = 0;
            while (i < index) {
                e = e.after;
                ++i;
            }
            return e;
        }
        BaseEntry e = this.endEntry;
        int i = this.size - 1;
        while (i > index) {
            e = e.before;
            --i;
        }
        return e;
    }

    /*
     * Unable to fully structure code
     */
    BaseEntry putEntry(int index, BaseEntry newEntry) {
        block4: {
            oldEntry = null;
            e = this.table[index];
            if (e != null) ** GOTO lbl17
            this.table[index] = newEntry;
            break block4;
lbl-1000:
            // 1 sources

            {
                if (e.next == null) {
                    e.next = newEntry;
                    break;
                }
                if (BaseParameters.eq(e.next, newEntry)) {
                    oldEntry = e.next;
                    if (oldEntry.next != null) {
                        newEntry.next = oldEntry.next;
                    }
                    e.next = newEntry;
                    BaseParameters.removeLinkList(oldEntry);
                    break;
                }
                e = e.next;
lbl17:
                // 2 sources

                ** while (e != null)
            }
        }
        return oldEntry;
    }

    int capacity(int size) {
        if (size == 0) {
            return 0;
        }
        int capacity = 1;
        int initialCapacity = size - 1;
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        while (capacity < initialCapacity) {
            capacity <<= 1;
        }
        return capacity;
    }

    int indexFor(int hashCode, int capacity) {
        return hashCode & capacity - 1;
    }

    int hash(String name) {
        int h = name.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    static void removeLinkList(BaseEntry oldEntry) {
        if (oldEntry.after != null) {
            oldEntry.after.before = oldEntry.before;
        }
        if (oldEntry.before != null) {
            oldEntry.before.after = oldEntry.after;
        }
    }

    static boolean eq(BaseEntry entry, BaseEntry entry2) {
        return entry.name.equals(entry2.name);
    }

    static int _hashCode(BaseParameters params) {
        int hashCode = 0;
        if (!params.isEmpty()) {
            BaseEntry e = params.endEntry.after;
            int i = 0;
            while (i < params.size) {
                hashCode += e.hashCode;
                e = e.after;
                ++i;
            }
        }
        return hashCode;
    }

    static class BaseEntry {
        final String name;
        final int hashCode;
        Object value;
        BaseEntry next;
        BaseEntry before;
        BaseEntry after;

        BaseEntry(String name, Object value, int hashCode) {
            this.name = name;
            this.hashCode = hashCode;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BaseEntry)) {
                return false;
            }
            BaseEntry e = (BaseEntry)o;
            return this.name.equals(e.getName()) && (this.value != null ? this.value.equals(e.getValue()) : e.getValue() == null);
        }

        public String toString() {
            return String.valueOf(this.name) + "=" + this.value;
        }
    }

    private class ParametersIterator
    implements Iterator {
        private int _index = -1;
        private BaseEntry e;

        ParametersIterator() {
            this.e = BaseParameters.this.endEntry;
        }

        public boolean hasNext() {
            return this.e != null && this._index + 1 < BaseParameters.this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                ++this._index;
            } else {
                throw new NoSuchElementException();
            }
            this.e = this.e.after;
            return this.e;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ParametersKayValueIterator
    implements KayValueIterator {
        BaseEntry e;
        int _index;

        ParametersKayValueIterator() {
            this.e = BaseParameters.this.endEntry;
            this._index = -1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.e != null && this._index + 1 < BaseParameters.this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                ++this._index;
            } else {
                throw new NoSuchElementException();
            }
            this.e = this.e.after;
            return this.getKey();
        }

        public Object getKey() {
            this.check();
            return this.e.name;
        }

        public Object getValue() {
            this.check();
            return this.e.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return BaseParameters.this.size;
        }

        void check() {
            if (this._index == -1) {
                throw new IllegalStateException();
            }
            if (this.e == null) {
                throw new NoSuchElementException();
            }
        }
    }
}

