/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import shohaku.core.collections.Group;
import shohaku.core.collections.KayValueIterator;
import shohaku.core.collections.Sequence;
import shohaku.core.collections.SequenceUtils;
import shohaku.core.helpers.Eval;
import shohaku.core.lang.Boxing;

public class KayValueIteratorUtils {
    public static KayValueIterator emptyKayValueIterator() {
        return new EmptyKayValueIterator();
    }

    public static KayValueIterator asKayValueIterator(Map map) {
        return new MapKayValueIterator(map);
    }

    public static KayValueIterator asKayValueIterator(Group group) {
        return new GroupKayValueIterator(group);
    }

    public static KayValueIterator indexKayValueIterator(List list) {
        return new SequenceKayValueIterator(list);
    }

    public static KayValueIterator indexKayValueIterator(Object[] a) {
        return new SequenceKayValueIterator(a);
    }

    public static KayValueIterator indexMappingKayValueIterator(List keys, List values) {
        return new IndexMappingSequenceKayValueIterator(keys, values);
    }

    public static KayValueIterator indexMappingKayValueIterator(Object[] keys, Object[] values) {
        return new IndexMappingSequenceKayValueIterator(keys, values);
    }

    public static KayValueIterator segmentKayValueIterator(List list) {
        return new KeyValueSequenceKayValueIterator(list);
    }

    public static KayValueIterator segmentKayValueIterator(Object[] a) {
        return new KeyValueSequenceKayValueIterator(a);
    }

    public static KayValueIterator segmentKayValueIterator(List list, int segment, int keyOffset, int valueOffset) {
        return KayValueIteratorUtils.segmentKayValueIterator(list, 0, segment, keyOffset, valueOffset);
    }

    public static KayValueIterator segmentKayValueIterator(Object[] a, int segment, int keyOffset, int valueOffset) {
        return KayValueIteratorUtils.segmentKayValueIterator(a, 0, segment, keyOffset, valueOffset);
    }

    public static KayValueIterator segmentKayValueIterator(List list, int start, int segment, int keyOffset, int valueOffset) {
        return new SegmentSequenceKayValueIterator(list, start, segment, keyOffset, valueOffset);
    }

    public static KayValueIterator segmentKayValueIterator(Object[] a, int start, int segment, int keyOffset, int valueOffset) {
        return new SegmentSequenceKayValueIterator(a, start, segment, keyOffset, valueOffset);
    }

    public static KayValueIterator defaultValueKayValueIterator(Object[] a, Object defaultValue) {
        return new DefaultValueKayValueIterator(a, defaultValue);
    }

    public static KayValueIterator defaultValueKayValueIterator(List list, Object defaultValue) {
        return new DefaultValueKayValueIterator(list, defaultValue);
    }

    private static class EmptyKayValueIterator
    implements KayValueIterator {
        EmptyKayValueIterator() {
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object getKey() {
            throw new NoSuchElementException();
        }

        public Object getValue() {
            throw new NoSuchElementException();
        }

        public Object setValue(Object value) {
            throw new NoSuchElementException();
        }

        public int size() {
            return 0;
        }

        public boolean hasNext() {
            return false;
        }
    }

    private static abstract class AbstractKayValueIterator
    implements KayValueIterator {
        AbstractKayValueIterator() {
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MapKayValueIterator
    extends AbstractKayValueIterator {
        private final Iterator entrys;
        private final int size;
        private Map.Entry _entry = null;

        MapKayValueIterator(Map m) {
            Set entrySet = m.entrySet();
            this.entrys = entrySet.iterator();
            this.size = entrySet.size();
        }

        public boolean hasNext() {
            return this.entrys.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this._next();
            return this.getKey();
        }

        public Object getKey() {
            return this.entry().getKey();
        }

        public Object getValue() {
            return this.entry().getValue();
        }

        public Object setValue(Object value) {
            return this.entry().setValue(value);
        }

        public int size() {
            return this.size;
        }

        private Map.Entry entry() {
            if (this._entry == null) {
                throw new IllegalStateException();
            }
            return this._entry;
        }

        private void _next() {
            this._entry = (Map.Entry)this.entrys.next();
        }
    }

    private static class GroupKayValueIterator
    extends AbstractKayValueIterator {
        private final Iterator entrys;
        private final int size;
        private Group.Entry _entry = null;

        GroupKayValueIterator(Group g) {
            Set entrySet = g.entrySet();
            this.entrys = entrySet.iterator();
            this.size = entrySet.size();
        }

        public boolean hasNext() {
            return this.entrys.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this._next();
            return this.getKey();
        }

        public Object getKey() {
            return this.entry().getKey();
        }

        public Object getValue() {
            return this.entry().getValues();
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.size;
        }

        private Group.Entry entry() {
            if (this._entry == null) {
                throw new IllegalStateException();
            }
            return this._entry;
        }

        private void _next() {
            this._entry = (Group.Entry)this.entrys.next();
        }
    }

    private static class SequenceKayValueIterator
    extends AbstractKayValueIterator {
        private final Sequence src;
        private final int size;
        private int _index = -1;

        SequenceKayValueIterator(Object[] src) {
            this(SequenceUtils.asSequence(src));
        }

        SequenceKayValueIterator(List src) {
            this(SequenceUtils.asSequence(src));
        }

        SequenceKayValueIterator(Sequence src) {
            this.src = src;
            this.size = src.size();
        }

        public boolean hasNext() {
            return this._index + 1 < this.size;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this._next();
            return this.getKey();
        }

        public Object getKey() {
            return Boxing.box(this.index());
        }

        public Object getValue() {
            return this.src.get(this.index());
        }

        public Object setValue(Object value) {
            return this.src.set(this.index(), value);
        }

        public int size() {
            return this.size;
        }

        private int index() {
            if (this._index == -1) {
                throw new IllegalStateException();
            }
            if (this.src.size() != this.size) {
                throw new ConcurrentModificationException();
            }
            return this._index;
        }

        private void _next() {
            ++this._index;
        }
    }

    private static class IndexMappingSequenceKayValueIterator
    extends AbstractKayValueIterator {
        private final Sequence keys;
        private final Sequence values;
        private final int size;
        private int _index = -1;

        IndexMappingSequenceKayValueIterator(Object[] keys, Object[] values) {
            this(SequenceUtils.asSequence(keys), SequenceUtils.asSequence(values));
        }

        IndexMappingSequenceKayValueIterator(List keys, List values) {
            this(SequenceUtils.asSequence(keys), SequenceUtils.asSequence(values));
        }

        IndexMappingSequenceKayValueIterator(Sequence keys, Sequence values) {
            if (keys == null || values == null) {
                throw new NullPointerException();
            }
            if (keys.size() == values.size()) {
                throw new IllegalArgumentException();
            }
            this.keys = keys;
            this.values = values;
            this.size = keys.size();
        }

        public boolean hasNext() {
            return this._index + 1 < this.size;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this._next();
            return this.getKey();
        }

        public Object getKey() {
            return this.keys.get(this.index());
        }

        public Object getValue() {
            return this.values.get(this.index());
        }

        public Object setValue(Object value) {
            return this.values.set(this.index(), value);
        }

        public int size() {
            return this.size;
        }

        private int index() {
            if (this._index == -1) {
                throw new IllegalStateException();
            }
            if (this.keys.size() != this.size || this.values.size() != this.size) {
                throw new ConcurrentModificationException();
            }
            return this._index;
        }

        private void _next() {
            ++this._index;
        }
    }

    private static class SegmentSequenceKayValueIterator
    extends AbstractKayValueIterator {
        private final int size;
        private final int segment;
        private final int keyOffset;
        private final int valueOffset;
        private final int start;
        private final Sequence src;
        private int _index = -1;

        SegmentSequenceKayValueIterator(Object[] src, int st, int segment, int koff, int voff) {
            this(SequenceUtils.asSequence(src), st, segment, koff, voff);
        }

        SegmentSequenceKayValueIterator(List src, int st, int segment, int koff, int voff) {
            this(SequenceUtils.asSequence(src), st, segment, koff, voff);
        }

        SegmentSequenceKayValueIterator(Sequence a, int st, int segment, int koff, int voff) {
            if (a == null) {
                throw new NullPointerException();
            }
            int size = a.size();
            if (!(Eval.isRange(segment, 0, size) && Eval.isRange(koff, 0, segment) && Eval.isRange(voff, 0, segment) && Eval.isRange(st, 0, size - 1))) {
                this.throwIllegalArgumentException(st, segment, koff, voff, size);
            }
            this.size = (size - st) / segment;
            this.segment = segment;
            this.keyOffset = koff;
            this.valueOffset = voff;
            this.start = st;
            this.src = a;
        }

        private void throwIllegalArgumentException(int st, int segment, int koff, int voff, int size) {
            throw new IllegalArgumentException("size:" + size + ", segment:" + segment + ", keyOffset:" + koff + ", valueOffset:" + voff + ", start:" + st);
        }

        public boolean hasNext() {
            return this._index + 1 < this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                ++this._index;
            } else {
                throw new NoSuchElementException();
            }
            return this.getKey();
        }

        public Object getKey() {
            return this.src.get(this.keyIndex());
        }

        public Object getValue() {
            return this.src.get(this.valueIndex());
        }

        public Object setValue(Object value) {
            return this.src.set(this.valueIndex(), value);
        }

        public int size() {
            return this.size;
        }

        private int keyIndex() {
            this.check();
            return this._index * this.segment + this.start + this.keyOffset;
        }

        private int valueIndex() {
            this.check();
            return this._index * this.segment + this.start + this.valueOffset;
        }

        private void check() {
            if (this._index < 0) {
                throw new IllegalStateException();
            }
        }
    }

    private static class KeyValueSequenceKayValueIterator
    extends AbstractKayValueIterator {
        private final int size;
        private final Sequence src;
        private int _index = -1;

        KeyValueSequenceKayValueIterator(Object[] src) {
            this(SequenceUtils.asSequence(src));
        }

        KeyValueSequenceKayValueIterator(List src) {
            this(SequenceUtils.asSequence(src));
        }

        KeyValueSequenceKayValueIterator(Sequence src) {
            if (src == null) {
                throw new NullPointerException("argument is null");
            }
            if (src.size() % 2 != 0) {
                throw new IllegalArgumentException("odd number, size:" + src.size());
            }
            this.size = src.size() / 2;
            this.src = src;
        }

        public boolean hasNext() {
            return this._index + 1 < this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                ++this._index;
            } else {
                throw new NoSuchElementException();
            }
            return this.getKey();
        }

        public Object getKey() {
            return this.src.get(this.keyIndex());
        }

        public Object getValue() {
            return this.src.get(this.valueIndex());
        }

        public Object setValue(Object value) {
            return this.src.set(this.valueIndex(), value);
        }

        public int size() {
            return this.size;
        }

        private int keyIndex() {
            this.check();
            return this._index * 2;
        }

        private int valueIndex() {
            this.check();
            return this._index * 2 + 1;
        }

        private void check() {
            if (this._index < 0) {
                throw new IllegalStateException();
            }
        }
    }

    private static class DefaultValueKayValueIterator
    extends AbstractKayValueIterator {
        private final Sequence sequence;
        private final Object defaultValue;
        private int _index = -1;

        DefaultValueKayValueIterator(Object[] src, Object defaultValue) {
            this(SequenceUtils.asSequence(src), defaultValue);
        }

        DefaultValueKayValueIterator(List src, Object defaultValue) {
            this(SequenceUtils.asSequence(src), defaultValue);
        }

        DefaultValueKayValueIterator(Sequence src, Object defaultValue) {
            this.sequence = src;
            this.defaultValue = defaultValue;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            if (this.hasNext()) {
                ++this._index;
            } else {
                throw new NoSuchElementException();
            }
            return this.getKey();
        }

        public boolean hasNext() {
            return this._index + 1 < this.sequence.size();
        }

        public Object getKey() {
            return this.sequence.get(this._index).toString();
        }

        public Object getValue() {
            return this.defaultValue;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.sequence.size();
        }
    }
}

