/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import shohaku.core.collections.params.ParametersUtils;
import shohaku.ginkgo.CacheContentNode;
import shohaku.ginkgo.Document;
import shohaku.ginkgo.EvaluationNode;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.NodeContext;
import shohaku.ginkgo.NodeCreateRule;
import shohaku.ginkgo.NodeRule;
import shohaku.ginkgo.Substitutor;
import shohaku.ginkgo.TagAttributes;

class SAXContentHandler
implements ContentHandler {
    private static final int NO_SKIP_BODY = -1;
    private final Ginkgo ginkgo;
    private final LinkedList stackCreateRule;
    private final LinkedList createRuleList;
    private final Substitutor hierarchicalSubstitutor;
    private String currentUri;
    private int skipBody;
    private boolean isCacheNode;
    static /* synthetic */ Class class$0;

    SAXContentHandler(Ginkgo ginkgo) {
        this.ginkgo = ginkgo;
        this.stackCreateRule = new LinkedList();
        this.createRuleList = new LinkedList();
        this.hierarchicalSubstitutor = new HierarchicalSubstitutor(this.stackCreateRule);
        this.currentUri = "";
        this.skipBody = -1;
        this.isCacheNode = false;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.skipBody != -1) {
            ++this.skipBody;
            return;
        }
        try {
            String tagName = SAXContentHandler.getNodeName(localName, qName);
            this.startElement(namespaceURI, tagName, localName, qName, new TagAttributes(atts));
        }
        catch (Exception e) {
            this.handleException("Ginkgo.startElement:", e);
        }
    }

    void startElement(String namespaceURI, String tagName, String localName, String qName, TagAttributes atts) throws SAXException {
        try {
            this.downCurrentURI(tagName);
            NodeCreateRule createRule = this.createNodeCreateRule(namespaceURI, tagName);
            NodeCreateRule parentRule = !this.empty() ? this.peek() : null;
            this.push(createRule);
            createRule.begin(this.currentUri, namespaceURI, tagName, localName, qName, atts, parentRule);
            Node node = createRule.getNodeObject();
            if (this.isCurrentRoot()) {
                Document doc = this.ginkgo.getDocument();
                doc.getContext().setRoot(node);
                String documentId = this.ginkgo.getDocumentCompositeRule().getDocumentId(doc, node);
                doc.setId(documentId);
            }
            if (node instanceof CacheContentNode) {
                this.isCacheNode = true;
            }
            if (node instanceof EvaluationNode) {
                this.startEvaluation(node);
            }
            this.ginkgo.getDocument().startElement(node);
        }
        catch (Exception e) {
            this.handleException("Ginkgo.startElement:", e);
        }
    }

    private boolean isCurrentRoot() {
        return this.size() == 1;
    }

    public void characters(char[] buffer, int start, int length) throws SAXException {
        if (this.skipBody != -1) {
            return;
        }
        try {
            if (!this.empty()) {
                NodeCreateRule createRule = this.peek();
                char[] chars = new char[length];
                System.arraycopy(buffer, start, chars, 0, length);
                createRule.addChars(this.currentUri, chars);
            }
        }
        catch (Exception e) {
            this.handleException("Ginkgo.characters:", e);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.skipBody != -1) {
            if (this.skipBody == 0) {
                this.skipBody = -1;
            } else {
                --this.skipBody;
                return;
            }
        }
        try {
            NodeCreateRule createRule = this.pop();
            Node node = createRule.getNodeObject();
            if (node instanceof CacheContentNode) {
                this.isCacheNode = false;
            }
            if (node instanceof EvaluationNode) {
                this.endEvaluation(node);
            }
            String name = SAXContentHandler.getNodeName(localName, qName);
            createRule.end(this.currentUri, namespaceURI, name, localName, qName);
            this.upCurrentURI();
            this.ginkgo.getDocument().endElement(node);
        }
        catch (Exception e) {
            this.handleException("Ginkgo.endElement:", e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            Iterator i = this.createRuleList.iterator();
            while (i.hasNext()) {
                NodeCreateRule createRule = (NodeCreateRule)i.next();
                createRule.finish();
            }
        }
        catch (Exception e) {
            this.handleException("Ginkgo.endDocument:", e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    private boolean empty() {
        return this.size() == 0;
    }

    private int size() {
        return this.stackCreateRule.size();
    }

    private void push(NodeCreateRule createRule) {
        this.stackCreateRule.addLast(createRule);
        this.createRuleList.add(createRule);
    }

    private NodeCreateRule pop() {
        return (NodeCreateRule)this.stackCreateRule.removeLast();
    }

    private NodeCreateRule peek() {
        return (NodeCreateRule)this.stackCreateRule.getLast();
    }

    private void startEvaluation(Node node) {
        int eval = ((EvaluationNode)((Object)node)).doInitBody();
        if (eval == 1) {
            this.skipBody = 0;
        }
    }

    private void endEvaluation(Node node) throws SAXException {
        EvaluationNode bodyEvalNode = (EvaluationNode)((Object)node);
        while (2 == bodyEvalNode.doEvalBody()) {
            this.evaluationChilds(node);
        }
    }

    private void evaluationContent(Node node) throws SAXException {
        NodeContext nc = node.getContext();
        String namespaceURI = nc.getNodeNamespaceURI();
        String tagName = nc.getNodeName();
        String localName = nc.getNodeLocalName();
        String qName = nc.getNodeQName();
        TagAttributes atts = nc.getTagAttributes();
        this.startElement(namespaceURI, tagName, localName, qName, atts);
        this.evaluationChilds(node);
        this.endElement(namespaceURI, localName, qName);
    }

    private void evaluationChilds(Node parent) throws SAXException {
        Iterator i = parent.getContext().childIterator();
        while (i.hasNext()) {
            Node child = (Node)i.next();
            if (child.isType(2)) {
                String text = child.getText();
                this.characters(text.toCharArray(), 0, text.length());
                continue;
            }
            this.evaluationContent(child);
        }
    }

    private NodeCreateRule createNodeCreateRule(String namespaceURI, String tagName) throws SAXException {
        if (this.isCacheNode) {
            NodeRule nodeRule = this.createCacheNodeRule();
            return new NodeCreateRule(this.ginkgo.getDocument(), nodeRule, null);
        }
        NodeRule nodeRule = this.findNodeRule(namespaceURI, tagName);
        if (nodeRule == null) {
            throw new SAXException("NodeRule couldn't be created. uri:" + this.currentUri + ", name:" + tagName);
        }
        return new NodeCreateRule(this.ginkgo.getDocument(), nodeRule, this.hierarchicalSubstitutor);
    }

    private NodeRule createCacheNodeRule() {
        NodeRule set = new NodeRule();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.ginkgo.CacheNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        set.setNodeClass(clazz.getName());
        set.setXAttributes(ParametersUtils.EMPTY_PARAMETERS);
        set.setPattern(this.currentUri);
        NodeRule nodeRule = set;
        return nodeRule;
    }

    private void downCurrentURI(String name) {
        StringBuffer sb = new StringBuffer(this.currentUri);
        sb.append('/');
        sb.append(name);
        this.currentUri = sb.toString();
    }

    private void upCurrentURI() {
        String uri = this.currentUri;
        int slash = uri.lastIndexOf(47);
        this.currentUri = slash >= 0 ? uri.substring(0, slash) : "";
    }

    private NodeRule findNodeRule(String namespaceURI, String tagName) {
        return this.ginkgo.getNodeCompositeRule().findNodeRule(namespaceURI, this.currentUri, tagName);
    }

    private void handleException(String msg, Exception e) throws SAXException {
        if (this.ginkgo.isErrThrowable()) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(msg, e);
        }
        this.error(msg, e);
    }

    private void error(Object message, Throwable t) {
        this.ginkgo.getLogger().error(message, t);
    }

    private static String getNodeName(String localName, String qName) {
        String name = localName;
        if (name == null || name.length() < 1) {
            name = qName;
        }
        return name;
    }

    private static class HierarchicalSubstitutor
    implements Substitutor {
        private List stack;

        HierarchicalSubstitutor(List stack) {
            this.stack = stack;
        }

        public TagAttributes substitute(Document document, String uri, String tagName, TagAttributes atts) {
            Iterator i = this.stack.iterator();
            Substitutor substitutor = null;
            while (i.hasNext()) {
                substitutor = ((NodeCreateRule)i.next()).getNodeRule().getSubstitutor();
                if (substitutor == null) continue;
                atts = substitutor.substitute(document, uri, tagName, atts);
            }
            return atts;
        }

        public String substitute(Document document, String uri, String tagName, String text) {
            Iterator i = this.stack.iterator();
            Substitutor substitutor = null;
            while (i.hasNext()) {
                substitutor = ((NodeCreateRule)i.next()).getNodeRule().getSubstitutor();
                if (substitutor == null) continue;
                text = substitutor.substitute(document, uri, tagName, text);
            }
            return text;
        }
    }
}

