/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.composer.node.util;

import java.util.Date;

import shohaku.composer.CompositeException;
import shohaku.composer.node.AbstractValueNode;
import shohaku.core.util.DateUtils;

/**
 * 日付型のデータを表す値型のノードを提供します。
 */
public class DateNode extends AbstractValueNode {

    /** デフォルトの日付書式(yyyy-mm-dd hh:mm:ss) 。 */
    public static final String DEFAULT_DATE_FORMAT = "yyyy-mm-dd hh:mm:ss";

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        String body = getText();
        String format = getAttribute("format", DEFAULT_DATE_FORMAT);
        Date date = DateUtils.parse(body, format);
        if (date == null) {
            throw new CompositeException("illegal Date format. value:" + body + ", format:" + format);
        }
        return date;
    }

}
