/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.composer.node.collection;

import java.util.Collections;
import java.util.List;

import shohaku.composer.CompositeException;
import shohaku.composer.Node;
import shohaku.composer.node.AbstractValueNode;

/**
 * <code>name</code> 属性またはタグ名をキーとする値の要素を一つ持つマップを生成するノードを提供します。
 */
public class NamedSingletonMapNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        List args = getNodeContext().getValueElementChildren();
        if (args.isEmpty()) {
            throw new CompositeException("プロパティの値要素が指定されていません。");
        }
        if (args.size() > 1) {
            throw new CompositeException("要素が１個以上の数指定されています。 size:" + args.size());
        }
        String key = getAttribute("name", getNodeContext().getNodeName());
        Object value = ((Node) args.get(0)).getNodeValue();
        return Collections.singletonMap(key, value);
    }

}
